/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

public class JavaClassInformationExtractorPhase
implements IGlobalExtractionPhase<ClassInformationValue, ClassInformation> {
    public List<ClassInformationValue> extract(ITokenElementContext fileContext) throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(fileContext.getRootEntity(ECodeViewOption.FILTERED));
        return this.extractLevel(typeResolver, fileContext, (List<ShallowEntity>)fileContext.getRootEntity(ECodeViewOption.FILTERED).getChildren()).toList();
    }

    private @NonNull Stream<ClassInformationValue> extractLevel(JavaImportSensitiveTypeResolver typeResolver, ITokenElementContext fileContext, List<ShallowEntity> children) {
        return Stream.concat(children.stream().flatMap(entity -> this.handleType(typeResolver, fileContext, (ShallowEntity)entity).stream()), children.stream().flatMap(entity -> this.extractLevel(typeResolver, fileContext, (List<ShallowEntity>)entity.getChildren())));
    }

    private Optional<ClassInformationValue> handleType(JavaImportSensitiveTypeResolver typeResolver, ITokenElementContext fileContext, ShallowEntity entity) {
        if (EShallowEntityType.TYPE != entity.getType() || "anonymous class".equals(entity.getSubtype())) {
            return Optional.empty();
        }
        boolean isInterface = "interface".equals(entity.getSubtype());
        List methodEntities = entity.getChildrenOfType(EShallowEntityType.METHOD);
        List<MethodInformation> methodInformation = methodEntities.stream().filter(methodEntity -> JavaClassInformationExtractorPhase.shouldIncludeMethod(methodEntity, isInterface)).map(methodEntity -> new MethodInformation(methodEntity.getName(), LanguageFeatureParser.JAVA.getParameterTypeNames(methodEntity).stream().flatMap(Optional::stream).toList())).toList();
        Set<String> possibleSuperclasses = JavaClassInformationExtractorPhase.getPossibleSuperclasses(typeResolver, entity);
        Set<Set<String>> possibleSuperinterfaces = JavaClassInformationExtractorPhase.getPossibleSuperinterfaces(typeResolver, entity);
        String fqn = LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(entity);
        return Optional.of(this.createValue(fileContext.getUniformPath(), fqn, new ClassInformation(possibleSuperclasses, possibleSuperinterfaces, methodInformation)));
    }

    private static boolean shouldIncludeMethod(ShallowEntity method, boolean isInterface) {
        Pair modifiersAndReturnType = LanguageFeatureParser.JAVA.getModifiersAndReturnType(method);
        if (modifiersAndReturnType == null) {
            return false;
        }
        if (isInterface) {
            return TokenStreamUtils.contains((List)((List)modifiersAndReturnType.getFirst()), (ETokenType)ETokenType.DEFAULT);
        }
        return !"constructor".equals(method.getSubtype()) && !TokenStreamUtils.containsAny((List)((List)modifiersAndReturnType.getFirst()), (ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.FINAL, ETokenType.STATIC, ETokenType.ABSTRACT});
    }

    private static Set<String> getPossibleSuperclasses(JavaImportSensitiveTypeResolver typeResolver, ShallowEntity entity) {
        if (!"class".equals(entity.getSubtype())) {
            return CollectionUtils.emptySet();
        }
        List superclass = LanguageFeatureParser.JAVA.getSuperclass(entity);
        if (superclass.isEmpty()) {
            return Collections.emptySet();
        }
        return LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(typeResolver, entity, TokenStreamTextUtils.concatTokenTexts((List)superclass));
    }

    private static Set<Set<String>> getPossibleSuperinterfaces(JavaImportSensitiveTypeResolver typeResolver, ShallowEntity entity) {
        return LanguageFeatureParser.JAVA.getExtendedOrImplementedInterfaces(entity).stream().map(interfaceName -> LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(typeResolver, entity, interfaceName)).collect(Collectors.toSet());
    }

    public ClassInformationValue createValue(String uniformPath, String className, ClassInformation additionalInformation) {
        return new ClassInformationValue(uniformPath, className, additionalInformation);
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public record ClassInformation(Set<String> possibleSuperclasses, Set<Set<String>> possibleSuperinterfaces, List<MethodInformation> methods) implements Serializable
    {
    }

    @IndexValueClass
    public record ClassInformationValue(String uniformPath, String fullyQualifiedClassName, ClassInformation classInformation) implements IExtractedValue<ClassInformation>
    {
        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.fullyQualifiedClassName;
        }

        public ClassInformation getAdditionalInformation() {
            return this.classInformation;
        }
    }

    @IndexValueClass
    public record MethodInformation(String methodName, List<String> parameterTypes) implements Serializable
    {
    }
}

