/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Check(id="cqse-java-lang-name", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaLangNameCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Type uses name from java.lang";
    @CheckOption(name="Type uses name from java.lang: Allow names from sub-packages", description="Determines whether class names from sub-packages of `java.lang` (e.g. `java.lang.reflect`) should be allowed or not.\n")
    private boolean allowSubPackages = false;
    private static final Map<String, Set<String>> JAVA_LANG_STAR_NAMES_PER_PACKAGE = Map.ofEntries(Map.entry("java.lang.annotation", Set.of("Annotation", "AnnotationFormatError", "AnnotationTypeMismatchException", "Documented", "ElementType", "IncompleteAnnotationException", "Inherited", "Native", "Repeatable", "Retention", "RetentionPolicy", "Target")), Map.entry("java.lang.constant", Set.of("ClassDesc", "Constable", "ConstantDesc", "ConstantDescs", "DirectMethodHandleDesc", "DynamicCallSiteDesc", "DynamicConstantDesc", "MethodHandleDesc", "MethodTypeDesc")), Map.entry("java.lang.instrument", Set.of("ClassDefinition", "ClassFileTransformer", "IllegalClassFormatException", "Instrumentation", "UnmodifiableClassException", "UnmodifiableModuleException")), Map.entry("java.lang.invoke", Set.of("CallSite", "ConstantBootstraps", "ConstantCallSite", "LambdaConversionException", "LambdaMetafactory", "MethodHandle", "MethodHandleInfo", "MethodHandleProxies", "MethodHandles", "MethodType", "MutableCallSite", "SerializedLambda", "StringConcatException", "StringConcatFactory", "SwitchPoint", "TypeDescriptor", "VarHandle", "VolatileCallSite", "WrongMethodTypeException")), Map.entry("java.lang.management", Set.of("BufferPoolMXBean", "ClassLoadingMXBean", "CompilationMXBean", "GarbageCollectorMXBean", "LockInfo", "ManagementFactory", "ManagementPermission", "MemoryMXBean", "MemoryManagerMXBean", "MemoryNotificationInfo", "MemoryPoolMXBean", "MemoryType", "MemoryUsage", "MonitorInfo", "OperatingSystemMXBean", "PlatformLoggingMXBean", "PlatformManagedObject", "RuntimeMXBean", "ThreadInfo", "ThreadMXBean")), Map.entry("java.lang.module", Set.of("Configuration", "FindException", "InvalidModuleDescriptorException", "ModuleDescriptor", "ModuleFinder", "ModuleReader", "ModuleReference", "ResolutionException", "ResolvedModule")), Map.entry("java.lang.ref", Set.of("Cleaner", "PhantomReference", "Reference", "ReferenceQueue", "SoftReference", "WeakReference")), Map.entry("java.lang.reflect", Set.of("AccessibleObject", "AnnotatedArrayType", "AnnotatedElement", "AnnotatedParameterizedType", "AnnotatedType", "AnnotatedTypeVariable", "AnnotatedWildcardType", "Array", "Constructor", "Executable", "Field", "GenericArrayType", "GenericDeclaration", "GenericSignatureFormatError", "InaccessibleObjectException", "InvocationHandler", "InvocationTargetException", "MalformedParameterizedTypeException", "MalformedParametersException", "Member", "Method", "Modifier", "Parameter", "ParameterizedType", "Proxy", "RecordComponent", "ReflectPermission", "Type", "TypeVariable", "UndeclaredThrowableException", "WildcardType")), Map.entry("java.lang.runtime", Set.of("ObjectMethods", "SwitchBootstraps")));

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        String className;
        String clashingPackage;
        if (((IToken)entity.includedTokens().get(0)).getType() != ETokenType.NEW && (clashingPackage = this.getClashingPackage(className = entity.getName())) != null) {
            this.buildFinding("`%s` clashes with name from `%s`".formatted(className, clashingPackage), this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private String getClashingPackage(String className) {
        if (JavaImportSensitiveTypeResolver.DEFAULT_JAVA_LANG_IMPORTED_CLASSES.contains(className)) {
            return "java.lang";
        }
        if (!this.allowSubPackages) {
            for (Map.Entry<String, Set<String>> packageWithTypes : JAVA_LANG_STAR_NAMES_PER_PACKAGE.entrySet()) {
                Set<String> typeNamesInPackage = packageWithTypes.getValue();
                if (!typeNamesInPackage.contains(className)) continue;
                return packageWithTypes.getKey();
            }
        }
        return null;
    }
}

