/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.UnusedImportsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-java-unused-imports", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaUnusedImportsCheck
extends UnusedImportsCheckBase {
    private static final String STAR = "*";
    private static final Pattern COMMENT_LINK_PATTERN = Pattern.compile("@(?:see|link|linkplain|throws|value)\\s+([^ \\t#}(\\n]+)?(?:[^ \\t}(\\n]*)(?:[(](.*?)[)])?", 32);
    private static final Pattern JAVADOC_PARAMETER_TYPE_SANITIZER = Pattern.compile("[\\s*]|\\.\\.\\.");

    @Override
    protected boolean isImportStatement(ShallowEntity entity) {
        return entity.getSubtype().equals("import");
    }

    @Override
    protected String getSimpleNameFromImport(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        String typeName = ((IToken)tokens.get(tokens.size() - 2)).getText();
        if (!STAR.equals(typeName)) {
            return typeName;
        }
        return null;
    }

    @Override
    protected void processComment(IToken token, ListMap<String, ShallowEntity> imports) {
        Matcher matcher = COMMENT_LINK_PATTERN.matcher(token.getText());
        while (matcher.find()) {
            String parameterString;
            if (matcher.group(1) != null) {
                Pair split = StringUtils.splitAtFirst((String)matcher.group(1), (String)".");
                if (StringUtils.isEmpty((String)((String)split.getFirst()))) continue;
                this.useType((String)split.getFirst(), imports);
            }
            if ((parameterString = matcher.group(2)) == null) continue;
            for (String parameter : parameterString.split(",")) {
                this.useType(JavaUnusedImportsCheck.getParameterType(parameter), imports);
            }
        }
    }

    private static String getParameterType(String parameter) {
        return JAVADOC_PARAMETER_TYPE_SANITIZER.matcher(parameter).replaceAll("");
    }

    @Override
    protected String getFullyQualifiedNameFromImport(ShallowEntity entity) {
        List identifiers = CollectionUtils.filterAndMap((Collection)entity.includedTokens(), token -> token.getType() == ETokenType.IDENTIFIER, IToken::getText);
        return StringUtils.concat((Iterable)identifiers, (String)".");
    }

    @Override
    protected void processEntity(ShallowEntity entity, ListMap<String, ShallowEntity> imports) {
        entity.includedTokens().stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).forEach(token -> this.useType(token.getText(), imports));
    }
}

