/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S6856", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingPathVariableAnnotationCheck
extends CheckImplementationBase {
    private static final Pattern IS_PROPERTY_PLACEHOLDER = Pattern.compile("\\$\\{.*}");
    private static final Pattern PATH_ARG_REGEX = Pattern.compile("\\{([^}:]+)(:([^{}]|\\{[^}]+})+)?}");
    private static final TokenPattern ANY_MAP_TYPE_PATTERN = TokenPattern.of().regex(".*Map").skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, false);
    private static final Set<String> REQUEST_MAPPING_ANNOTATIONS = Set.of("GetMapping", "org.springframework.web.bind.annotation.GetMapping", "PostMapping", "org.springframework.web.bind.annotation.PostMapping", "PutMapping", "org.springframework.web.bind.annotation.PutMapping", "DeleteMapping", "org.springframework.web.bind.annotation.DeleteMapping");
    private static final Set<String> PATH_VARIABLE_OR_REQUEST_PARAM_ANNOTATION = Set.of("org.springframework.web.bind.annotation.PathVariable", "org.springframework.web.bind.annotation.RequestParam");

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            List methods = type.getChildrenOfType(EShallowEntityType.METHOD);
            Set<String> knownParameters = MissingPathVariableAnnotationCheck.extractModelAttributeKnownParameters(methods);
            for (ShallowEntity method : methods) {
                MissingPathVariableAnnotationCheck.getRelatedAnnotations(method).forEach(annotation -> this.handleAnnotation(method, (ShallowEntity)annotation, knownParameters));
            }
        }
    }

    private static Set<String> extractModelAttributeKnownParameters(List<ShallowEntity> methods) {
        HashSet<String> knownParameters = new HashSet<String>();
        for (ShallowEntity method : methods) {
            if (LanguageFeatureParser.JAVA.getAnnotations(method).stream().noneMatch(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, Set.of("ModelAttribute", "org.springframework.web.bind.annotation.ModelAttribute")))) continue;
            List methodParameters = LanguageFeatureParser.JAVA.getSplitParameterTokens(method);
            knownParameters.addAll(methodParameters.stream().flatMap(parameterTokens -> MissingPathVariableAnnotationCheck.getParameterIdentifier(parameterTokens).stream()).collect(Collectors.toSet()));
        }
        return knownParameters;
    }

    private void handleAnnotation(ShallowEntity method, ShallowEntity annotation, Set<String> modelAttributeKnownParameters) {
        List methodParameters = LanguageFeatureParser.JAVA.getSplitParameterTokens(method);
        boolean hasMapParameter = methodParameters.stream().anyMatch(tokens1 -> LanguageFeatureParser.JAVA.getMethodParameterAnnotationParameters(tokens1, PATH_VARIABLE_OR_REQUEST_PARAM_ANNOTATION).size() == 1 && ANY_MAP_TYPE_PATTERN.matchesAnywhere(tokens1));
        if (hasMapParameter) {
            return;
        }
        List tokens = LanguageFeatureParser.JAVA.getAnnotationParameterTokens(annotation);
        if (tokens.isEmpty()) {
            return;
        }
        Map parameters = LanguageFeatureParser.JAVA.extractAnnotationParameters(tokens, Set.of("path", "value"));
        Set<String> knownParameters = Stream.concat(methodParameters.stream().flatMap(parameterTokens -> MissingPathVariableAnnotationCheck.getParameterIdentifier(parameterTokens).stream()), modelAttributeKnownParameters.stream()).collect(Collectors.toSet());
        List values = (List)parameters.get("value");
        if (values != null) {
            this.checkAnnotation(annotation, values, knownParameters);
        }
        if ((values = (List)parameters.get("path")) != null) {
            this.checkAnnotation(annotation, values, knownParameters);
        }
    }

    private void checkAnnotation(ShallowEntity annotation, List<JavaLanguageFeatureParser.ParameterValue> values, Set<String> knownParameters) {
        for (JavaLanguageFeatureParser.ParameterValue value : values) {
            if (IS_PROPERTY_PLACEHOLDER.matcher(value.getValue()).find()) continue;
            Matcher matcher = PATH_ARG_REGEX.matcher(value.getValue());
            while (matcher.find()) {
                if (knownParameters.contains(StringUtils.stripPrefix((String)matcher.group(1), (String)"*"))) continue;
                this.buildFinding("Missing method parameter for path parameter " + MarkupUtils.formatAsSourceCode((String)matcher.group(1)), this.buildLocation().forEntity(annotation)).createAndStore();
            }
        }
    }

    private static Optional<String> getParameterIdentifier(List<IToken> parameterTokens) {
        List optionalAnnotationParameterTokens = LanguageFeatureParser.JAVA.getMethodParameterAnnotationParameters(parameterTokens, PATH_VARIABLE_OR_REQUEST_PARAM_ANNOTATION);
        if (optionalAnnotationParameterTokens.size() != 1) {
            return Optional.empty();
        }
        List annotationParameterTokens = (List)optionalAnnotationParameterTokens.getFirst();
        if (!annotationParameterTokens.isEmpty()) {
            Map parameters = LanguageFeatureParser.JAVA.extractAnnotationParameters(annotationParameterTokens.subList(1, annotationParameterTokens.size() - 1), Set.of("name", "value"));
            List values = (List)parameters.get("value");
            if (values != null) {
                return Optional.of(((JavaLanguageFeatureParser.ParameterValue)values.getFirst()).getValue());
            }
            values = (List)parameters.get("name");
            if (values != null) {
                return Optional.of(((JavaLanguageFeatureParser.ParameterValue)values.getFirst()).getValue());
            }
        }
        IToken identifier = parameterTokens.getLast();
        return Optional.of(identifier.getText());
    }

    private static Stream<ShallowEntity> getRelatedAnnotations(ShallowEntity method) {
        return LanguageFeatureParser.JAVA.getAnnotations(method).stream().filter(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, REQUEST_MAPPING_ANNOTATIONS));
    }
}

