/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S4738", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ReplaceGuavaWithJavaCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Use `%s` instead";
    private static final int CLASS_NAME_GROUP = 0;
    private static final int METHOD_GROUP = 1;
    private static final String GOOGLE_PACKAGE = "com.google.common";
    private static final String GUAVA_BASE_ENCODING = "com.google.common.io.BaseEncoding";
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    private static final String GUAVA_FILES = "com.google.common.io.Files";
    private static final String GUAVA_IMMUTABLE_LIST = "com.google.common.collect.ImmutableList";
    private static final String GUAVA_PREDICATE = "com.google.common.base.Predicate";
    private static final String GUAVA_FUNCTION = "com.google.common.base.Function";
    private static final String GUAVA_SUPPLIER = "com.google.common.base.Supplier";
    private static final Map<String, String> CLASS_MAPPINGS = Map.of("com.google.common.base.Predicate", "java.util.function.Predicate", "com.google.common.base.Function", "java.util.function.Function", "com.google.common.base.Supplier", "java.util.function.Supplier", "com.google.common.base.Optional", "java.util.Optional", "com.google.common.io.Files", "java.nio.file.Files", "com.google.common.io.BaseEncoding", "java.util.Base64", "com.google.common.collect.ImmutableList", "java.util.List");
    private static final Map<String, String> METHOD_MAPPINGS = Map.of("of", "of", "absent", "empty", "fromNullable", "ofNullable", "createTempDir", "createTempDirectory");
    private static final Set<TokenPattern> PATTERNS;

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List<ShallowEntity> entities = ShallowEntityTraversalUtils.listAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption())).stream().filter(entity -> !Objects.equals(entity.getSubtype(), "import") || entity.getType() != EShallowEntityType.META).toList();
        for (ShallowEntity shallowEntity : entities) {
            for (TokenPattern pattern : PATTERNS) {
                for (TokenPatternMatch match : pattern.findNonOverlappingMatches((List)shallowEntity.ownStartTokens())) {
                    this.handleMatch(typeResolver, match);
                }
            }
        }
    }

    private void handleMatch(JavaImportSensitiveTypeResolver typeResolver, TokenPatternMatch match) {
        String javaMethod;
        String groupString = match.groupString(0);
        String guavaClass = groupString.startsWith(GOOGLE_PACKAGE) ? groupString : typeResolver.getFullyQualifiedTypeName(groupString);
        Object javaReplacement = CLASS_MAPPINGS.get(guavaClass);
        if (javaReplacement == null) {
            return;
        }
        ArrayList guavaTokens = new ArrayList(match.groupTokens(0));
        String guavaMethod = match.groupString(1);
        if (!guavaMethod.isEmpty() && (javaMethod = METHOD_MAPPINGS.get(guavaMethod)) != null) {
            javaReplacement = (String)javaReplacement + "." + javaMethod;
            guavaTokens.addAll(match.groupTokens(1));
        }
        this.buildFinding(MESSAGE.formatted(javaReplacement), this.buildLocation().forTokens(guavaTokens)).createAndStore();
    }

    private static Set<TokenPattern> createAlwaysPatterns(String guavaClass) {
        List<String> split = Arrays.asList(StringUtils.splitByWholeSeparator((String)guavaClass, (String)"."));
        List<String> packageNames = split.subList(0, split.size() - 1);
        String className = split.getLast();
        TokenPattern fullyQualifiedPattern = new TokenPattern();
        for (String packageName : packageNames) {
            fullyQualifiedPattern = fullyQualifiedPattern.tokenText(packageName).group(0).sequence(new Object[]{ETokenType.DOT}).group(0);
        }
        fullyQualifiedPattern = fullyQualifiedPattern.tokenText(className).group(0);
        TokenPattern simplePattern = new TokenPattern().notPrecededBy((Object)ETokenType.DOT).tokenText(className).group(0);
        return Set.of(fullyQualifiedPattern, simplePattern);
    }

    private static Set<TokenPattern> createClassPattern(String guavaClass) {
        return ReplaceGuavaWithJavaCheck.createAlwaysPatterns(guavaClass).stream().map(pattern -> pattern.notFollowedBy((Object)ETokenType.DOT)).collect(Collectors.toSet());
    }

    private static Set<TokenPattern> createMethodPatterns(String guavaClass, Set<String> methods) {
        return ReplaceGuavaWithJavaCheck.createAlwaysPatterns(guavaClass).stream().map(pattern -> pattern.sequence(new Object[]{ETokenType.DOT}).regex(String.join((CharSequence)"|", methods)).group(1)).collect(Collectors.toSet());
    }

    static {
        HashSet<TokenPattern> patterns = new HashSet<TokenPattern>();
        patterns.addAll(ReplaceGuavaWithJavaCheck.createMethodPatterns(GUAVA_BASE_ENCODING, Set.of("base64", "base64Url")));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createMethodPatterns(GUAVA_FILES, Set.of("createTempDir")));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createMethodPatterns(GUAVA_IMMUTABLE_LIST, Set.of("of")));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createMethodPatterns(GUAVA_OPTIONAL, Set.of("of", "absent", "empty", "fromNullable", "ofNullable")));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createAlwaysPatterns(GUAVA_PREDICATE));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createAlwaysPatterns(GUAVA_FUNCTION));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createAlwaysPatterns(GUAVA_SUPPLIER));
        patterns.addAll(ReplaceGuavaWithJavaCheck.createClassPattern(GUAVA_OPTIONAL));
        PATTERNS = UnmodifiableSet.of(patterns);
    }
}

