/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-suppress-warnings-annotation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SuppressWarningsAnnotationCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid using SuppressWarnings";
    @CheckOption(name="Avoid using SuppressWarnings - Forbidden tokens", description="The warnings that are not allowed to be suppressed. Separated by commas. Default is \"all,serial,hiding\". If the parameter is empty, all suppressed warning tokens are forbidden.")
    private Set<String> forbiddenSuppressedWarnings = CollectionUtils.asHashSet((Object[])new String[]{"all", "serial", "hiding"});
    private String suppressedWarningInFinding;
    private boolean allWarningsAreForbidden = false;

    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity meta : metaEntities) {
            if (!meta.getSubtype().equals("annotation") || !"SuppressWarnings".equals(meta.getName())) continue;
            this.processEntity(meta);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List suppressedWarnings = TokenStreamUtils.getTokenTextsByType((List)entity.includedTokens(), (ETokenType)ETokenType.STRING_LITERAL);
        if (this.isForbiddenSuppressedWarningTypeUsed(this.forbiddenSuppressedWarnings, suppressedWarnings)) {
            this.buildFinding(this.getFindingMessage(), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private String getFindingMessage() {
        if (this.allWarningsAreForbidden) {
            return "SuppressWarning should be avoided";
        }
        return "Warning of type '" + this.suppressedWarningInFinding + "' should not be suppressed";
    }

    private static String removeQuotesFromToken(String token) {
        return token.substring(1, token.length() - 1);
    }

    private boolean isForbiddenSuppressedWarningTypeUsed(Set<String> forbiddenWarnings, List<String> usedSuppressedWarnings) {
        if (forbiddenWarnings.isEmpty()) {
            this.allWarningsAreForbidden = true;
            return true;
        }
        for (String usedSuppressedWarning : usedSuppressedWarnings) {
            String usedSuppressedWarningType = SuppressWarningsAnnotationCheck.removeQuotesFromToken(usedSuppressedWarning);
            if (!forbiddenWarnings.contains(usedSuppressedWarningType)) continue;
            this.suppressedWarningInFinding = usedSuppressedWarningType;
            return true;
        }
        return false;
    }
}

