/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-document-thread-safe-classes", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DocumentThreadSafeClassesCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Document thread-safe classes";
    @CheckOption(name="Document thread-safe classes - Concurrency APIs", description="Regular expression for identifying Java imports which, when used, hint at the class being thread-safe..")
    private String concurrencyApiRegex = "java\\.util\\.concurrent\\.(?!Callable|TimeUnit)";
    private Pattern concurrencyApiPattern;
    @CheckOption(name="Document thread-safe classes - Comments documenting thread-safety", description="If the regular expression matches the comment then it is considered as documenting the fact that the class is thread-safe.")
    private String threadSafeRegex = "thread-?safe|concurren(t|cy)|parallel";
    private Pattern threadSafePattern;

    public void initialize() throws CheckException {
        super.initialize();
        this.concurrencyApiPattern = Pattern.compile(this.concurrencyApiRegex);
        this.threadSafePattern = Pattern.compile(this.threadSafeRegex, 32);
    }

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype()) && !"enum".equals(type.getSubtype())) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity type) throws CheckException {
        if (!this.mightBeThreadSafe(type)) {
            return;
        }
        Optional<IToken> javadocComment = this.findJavadocComment(type);
        if (!javadocComment.isPresent() || !this.isUsefulComment(javadocComment.get())) {
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntity(type)).createAndStore();
        }
    }

    private boolean mightBeThreadSafe(ShallowEntity type) throws CheckException {
        return DocumentThreadSafeClassesCheck.hasSynchronizedMethod(type) || DocumentThreadSafeClassesCheck.hasVolativeFields(type) || this.hasConcurrencyApiImports(type);
    }

    private static boolean hasSynchronizedMethod(ShallowEntity type) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(Collections.singleton(type), (EShallowEntityType)EShallowEntityType.METHOD).stream().anyMatch(method -> TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.SYNCHRONIZED));
    }

    private static boolean hasVolativeFields(ShallowEntity type) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(Collections.singleton(type), (EShallowEntityType)EShallowEntityType.ATTRIBUTE).stream().anyMatch(method -> TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.VOLATILE));
    }

    private boolean hasConcurrencyApiImports(ShallowEntity type) throws CheckException {
        ShallowEntity root = (ShallowEntity)ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)type, entity -> entity.getParent() == null).orElseThrow(() -> new CheckException("No root entity; should never happen."));
        return DocumentThreadSafeClassesCheck.select((ShallowEntity)root, (String)"./META[subtype('import')]").stream().anyMatch(importStatement -> this.isConcurrencyApiImport(importStatement.toString()));
    }

    private boolean isConcurrencyApiImport(String importStatement) {
        return this.concurrencyApiPattern.matcher(importStatement).find();
    }

    private boolean isUsefulComment(IToken commentToken) {
        String commentContent = LanguageProperties.of((ELanguage)commentToken.getLanguage()).getCommentContent(commentToken.getText());
        return this.threadSafePattern.matcher(commentContent).find();
    }

    private Optional<IToken> findJavadocComment(ShallowEntity type) throws CheckException {
        UnmodifiableList allTokens = this.context.getTokens(this.getCodeViewOption());
        ListIterator it = allTokens.listIterator(TokenStreamUtils.indexOfByOffset((List)allTokens, (int)type.getStartOffset()));
        List annotations = LanguageFeatureParser.JAVA.getAnnotations(type);
        while (it.hasPrevious()) {
            IToken token = (IToken)it.previous();
            if (DocumentThreadSafeClassesCheck.isInside(token, annotations)) continue;
            if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) break;
            if (token.getType() != ETokenType.DOCUMENTATION_COMMENT) continue;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    private static boolean isInside(IToken token, Collection<ShallowEntity> entities) {
        return entities.stream().anyMatch(entity -> DocumentThreadSafeClassesCheck.isInside(token, entity));
    }

    private static boolean isInside(IToken token, ShallowEntity entity) {
        return entity.getStartOffset() <= token.getOffset() && token.getEndOffset() <= entity.getEndOffset();
    }
}

