/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5808", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AuthorizationsStrongDecisionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_ACCESS_DECISION_VOTER = "`vote` method should return at least one time `ACCESS_DENIED`";
    private static final String FINDING_MESSAGE_PERMISSION_EVALUATOR = "`hasPermission` method should return at least one time `false`";
    private static final TokenPattern RETURN_VARIABLE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RETURN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.SEMICOLON});
    private static final TokenPattern RETURN_METHOD_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RETURN}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
    private static final TokenPattern FALSE_ASSIGNMENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.EQ, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"false"})})});
    private static final TokenPattern RETURN_FALSE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RETURN, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"false"})})});

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE);
        boolean accessPackageImported = !LanguageFeatureParser.JAVA.getImportsByPrefix(ast, new String[]{"org.springframework.security.access."}).isEmpty();
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype())) continue;
            if (AuthorizationsStrongDecisionsCheck.implementsInterface(type, "org.springframework.security.access.AccessDecisionVoter", accessPackageImported)) {
                List<ShallowEntity> voteMethods = AuthorizationsStrongDecisionsCheck.getOverriddenMethodWithName(type, "vote", 3, 3);
                for (ShallowEntity voteMethod : voteMethods) {
                    this.analyzeVoteMethod(voteMethod);
                }
            }
            if (!AuthorizationsStrongDecisionsCheck.implementsInterface(type, "org.springframework.security.access.PermissionEvaluator", accessPackageImported)) continue;
            List<ShallowEntity> hasPermissionMethods = AuthorizationsStrongDecisionsCheck.getOverriddenMethodWithName(type, "hasPermission", 3, 4);
            for (ShallowEntity hasPermissionMethod : hasPermissionMethods) {
                this.analyzeHasPermissionMethod(hasPermissionMethod);
            }
        }
    }

    private void analyzeVoteMethod(ShallowEntity method) {
        List<IToken> methodTokens = AuthorizationsStrongDecisionsCheck.getRelevantTokens(method);
        if (AuthorizationsStrongDecisionsCheck.throwsException(methodTokens) || AuthorizationsStrongDecisionsCheck.usesAccessDenied(methodTokens) || AuthorizationsStrongDecisionsCheck.returnsMethodCallResult(methodTokens)) {
            return;
        }
        this.buildFinding(FINDING_MESSAGE_ACCESS_DECISION_VOTER, this.buildLocation().forEntity(method)).createAndStore();
    }

    private void analyzeHasPermissionMethod(ShallowEntity method) {
        List<IToken> methodTokens = AuthorizationsStrongDecisionsCheck.getRelevantTokens(method);
        if (AuthorizationsStrongDecisionsCheck.throwsException(methodTokens) || AuthorizationsStrongDecisionsCheck.returnsMethodCallResult(methodTokens) || AuthorizationsStrongDecisionsCheck.returnsFalseLiteral(methodTokens) || AuthorizationsStrongDecisionsCheck.returnFalseVariable(methodTokens)) {
            return;
        }
        this.buildFinding(FINDING_MESSAGE_PERMISSION_EVALUATOR, this.buildLocation().forEntity(method)).createAndStore();
    }

    private static boolean throwsException(List<IToken> methodTokens) {
        return TokenStreamUtils.contains(methodTokens, (ETokenType)ETokenType.THROW);
    }

    private static boolean usesAccessDenied(List<IToken> includedTokens) {
        return TokenStreamUtils.firstTokenOfTypeWithText(includedTokens, (int)0, (int)includedTokens.size(), Set.of(ETokenType.IDENTIFIER), (String)"ACCESS_DENIED") != -1;
    }

    private static boolean returnsMethodCallResult(List<IToken> methodTokens) {
        if (RETURN_METHOD_CALL_PATTERN.matchesAnywhere(methodTokens)) {
            return true;
        }
        List matches = RETURN_VARIABLE_PATTERN.findAll(methodTokens);
        Set returnedVariables = matches.stream().map(m -> m.groupTexts(0)).flatMap(Collection::stream).collect(Collectors.toSet());
        return returnedVariables.stream().anyMatch(var -> new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{var})}), ETokenType.EQ}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).matchesAnywhere(methodTokens));
    }

    private static boolean implementsInterface(ShallowEntity type, String fullQualifiedInterfaceName, boolean accessPackageImported) {
        String simpleName;
        List implementedInterfaces = LanguageFeatureParser.JAVA.getImplementedInterfacesOfClass(type);
        return implementedInterfaces.contains(simpleName = (String)StringUtils.splitAtLast((String)fullQualifiedInterfaceName, (char)'.').getSecond()) && accessPackageImported || implementedInterfaces.contains(fullQualifiedInterfaceName);
    }

    private static List<ShallowEntity> getOverriddenMethodWithName(ShallowEntity type, String methodName, int minNumberOfParameters, int maxNumberOfParameters) {
        List methods = type.getChildrenOfType(EShallowEntityType.METHOD);
        ArrayList<ShallowEntity> overriddenMethods = new ArrayList<ShallowEntity>();
        for (ShallowEntity method : methods) {
            int numberOfParameters;
            if (!methodName.equals(method.getName()) || (numberOfParameters = LanguageFeatureParser.JAVA.getSplitParameterTokens(method).size()) < minNumberOfParameters || numberOfParameters > maxNumberOfParameters) continue;
            overriddenMethods.add(method);
        }
        return overriddenMethods;
    }

    private static boolean returnsFalseLiteral(List<IToken> methodTokens) {
        return RETURN_FALSE_PATTERN.matchesAnywhere(methodTokens);
    }

    private static boolean returnFalseVariable(List<IToken> methodTokens) {
        List returnMatches = RETURN_VARIABLE_PATTERN.findAll(methodTokens);
        Set returnedVariables = returnMatches.stream().map(m -> m.groupTexts(0)).flatMap(Collection::stream).collect(Collectors.toSet());
        List assignmentMatches = FALSE_ASSIGNMENT_PATTERN.findAll(methodTokens);
        Set falseVariables = assignmentMatches.stream().map(m -> m.groupTexts(0)).flatMap(Collection::stream).collect(Collectors.toSet());
        return !CollectionUtils.intersectionSet(falseVariables, (Collection[])new Collection[]{returnedVariables}).isEmpty();
    }

    private static List<IToken> getRelevantTokens(ShallowEntity method) {
        List excludedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)method.getChildren(), Set.of(EShallowEntityType.METHOD, EShallowEntityType.TYPE));
        UnmodifiableList includedTokens = method.includedTokens();
        Set excludedTokens = excludedEntities.stream().flatMap(e -> e.includedTokens().stream()).collect(Collectors.toSet());
        return includedTokens.stream().filter(token -> !excludedTokens.contains(token)).toList();
    }
}

