/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S6829", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AutowiredOnConstructorWhenMultipleConstructorsCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Add `@Autowired` to one of the constructors";
    private static final Set<String> SPRING_TYPE_ANNOTATIONS = Set.of("Bean", "org.springframework.context.annotation.Bean", "Configuration", "org.springframework.context.annotation.Configuration", "Component", "org.springframework.stereotype.Component", "Controller", "org.springframework.stereotype.Controller", "Repository", "org.springframework.stereotype.Repository", "Service", "org.springframework.stereotype.Service");

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(this::handleType);
    }

    private void handleType(ShallowEntity type) {
        if (!AutowiredOnConstructorWhenMultipleConstructorsCheck.isSpringType(type)) {
            return;
        }
        List<ShallowEntity> constructors = AutowiredOnConstructorWhenMultipleConstructorsCheck.getConstructorsOfType(type);
        if (constructors.size() <= 1) {
            return;
        }
        if (AutowiredOnConstructorWhenMultipleConstructorsCheck.containsAutowiredConstructor(constructors)) {
            return;
        }
        this.buildFinding(MESSAGE, this.buildLocation().forEntityFirstLine(type)).createAndStore();
    }

    private static boolean isSpringType(ShallowEntity type) {
        return LanguageFeatureParser.JAVA.getAnnotations(type).stream().anyMatch(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SPRING_TYPE_ANNOTATIONS));
    }

    private static List<ShallowEntity> getConstructorsOfType(ShallowEntity type) {
        return type.getChildren().stream().filter(child -> LanguageFeatureParser.JAVA.isConstructorOfType(type, child)).toList();
    }

    private static boolean containsAutowiredConstructor(List<ShallowEntity> constructors) {
        return constructors.stream().anyMatch(AutowiredOnConstructorWhenMultipleConstructorsCheck::isAutowired);
    }

    private static boolean isAutowired(ShallowEntity constructor) {
        return LanguageFeatureParser.JAVA.getAnnotations(constructor).stream().anyMatch(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.AUTOWIRE_ANNOTATIONS));
    }
}

