/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.RegexPattern;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class PythonImportAwareFindingsPattern {
    private final TokenPattern pattern;
    private final String importStatement;
    private final Function<List<IToken>, String> findingMessageProvider;

    public PythonImportAwareFindingsPattern(TokenPattern pattern, String importStatement, String findingsMessage) {
        this(pattern, importStatement, (List<IToken> token) -> findingsMessage);
    }

    public PythonImportAwareFindingsPattern(String tokenText, String importStatement, String findingsMessage) {
        this(new TokenPattern().sequence(new Object[]{new RegexPattern("^" + tokenText + "$")}).group(0), importStatement, findingsMessage);
    }

    public PythonImportAwareFindingsPattern(TokenPattern pattern, String importStatement, Function<List<IToken>, String> findingMessageProvider) {
        this.pattern = pattern;
        this.importStatement = importStatement;
        this.findingMessageProvider = findingMessageProvider;
    }

    public List<TokenPatternMatch> getMatches(List<IToken> tokens, UnmodifiableSet<String> imports) {
        if (imports.contains((Object)this.importStatement)) {
            return Collections.emptyList();
        }
        return this.pattern.findAll(tokens);
    }

    public String getFindingsMessage(List<IToken> tokens) {
        return this.findingMessageProvider.apply(tokens);
    }
}

