/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python2;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.RegexPattern;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-raising-exceptions-compatibility-python2", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class RaisingExceptionsCompatibilityPython2Check
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        TokenPattern pattern = RaisingExceptionsCompatibilityPython2Check.getFindingPattern();
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            this.buildFinding("Raising exceptions is used in an incompatible way", this.buildLocation().forTokens(matchedTokens)).createAndStore();
        }
    }

    private static TokenPattern getFindingPattern() {
        TokenPattern withTraceback = new TokenPattern().sequence(new Object[]{ETokenType.RAISE}).skipTo(new Object[]{new RegexPattern("^with_traceback$")});
        TokenPattern from = new TokenPattern().sequence(new Object[]{ETokenType.RAISE}).skipTo(new Object[]{ETokenType.FROM});
        return new TokenPattern().alternative(new Object[]{withTraceback, from}).group(0);
    }
}

