/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLineLayoutUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse.jmaab.db_0032", languages={ELanguage.SIMULINK})
public class SimulinkSignalAppearanceCheck
extends CheckImplementationBase {
    private static final int MAX_VALID_SUB_LINES_AT_INTERSECTION = 2;
    private static final double DOUBLE_COMPARISON_THRESHOLD = 0.1;
    @CheckOption(name="Check if horizontal or vertical signals cross", description="Report a finding if two horizontal or vertical signals cross (db_0032_a). Slanted signal lines are ignored here.")
    private boolean checkForSignalLineCrossing = true;
    @CheckOption(name="Check if signals overlap with other signals", description="Report a finding if a signals line is positioned over another signal line (db_0032_b).")
    private boolean checkForSignalLineOverlap = true;
    @CheckOption(name="Check if signals intersect with blocks", description="Indicates whether or not signal lines intersect with blocks (db_0032_c).")
    private boolean checkForSignalAndBlockIntersection = true;
    @CheckOption(name="Check whether signals split into more than two sub lines at an intersection", description="Report a finding if one intersection in a line splits into more than two sub lines (db_0032_d).")
    private boolean checkForSplitOfSignalLines = true;
    @CheckOption(name="Check if signals are drawn as slanting lines", description="Indicates whether or not to check for slanting signal lines (db_0032_e).")
    private boolean checkForSlantLines = true;
    private static final FindingPropertyList RECOMMENDED_ACTION_SIGNAL_CROSSING = FindingPropertyList.singleton((String)"Recommended Action", (String)"If possible, reposition the signal lines to avoid the crossing.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SIGNAL_CROSSES_BLOCK = FindingPropertyList.singleton((String)"Recommended Action", (String)"Reposition the signal line or block to avoid the intersection.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SIGNAL_SPLIT_TO_SUBLINES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect to a new branching point on one of the sub lines.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SLANT_LINE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Resize line to be vertical and/or horizontal.");
    private static final String SIGNAL_CROSS_BLOCK_FINDING_MESSAGE_FORMAT = "Line intersects with block: {0}";

    public void execute() {
        SimulinkModel simulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (simulinkModel == null) {
            return;
        }
        this.checkSignalLinesInSubsystem((SimulinkBlock)simulinkModel);
        for (SimulinkBlock subsystem : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)simulinkModel, Set.of("SubSystem"), (boolean)false, (boolean)false)) {
            this.checkSignalLinesInSubsystem(subsystem);
        }
    }

    private void checkSignalLinesInSubsystem(SimulinkBlock subsystem) {
        if (subsystem.isStateflowChartBlock() || StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)subsystem) || SimulinkUtils.isMaskedSubsystem((SimulinkBlock)subsystem)) {
            return;
        }
        UnmodifiableCollection lines = subsystem.getContainedLines();
        Map<SimulinkLine, List<Segment>> lineSegmentsMap = SimulinkSignalAppearanceCheck.mapToSegments((Collection<SimulinkLine>)lines);
        if (this.checkForSignalLineCrossing) {
            this.checkForSignalLineCrossingInSubsystem(lineSegmentsMap);
        }
        if (this.checkForSignalLineOverlap) {
            this.checkForSignalLineOverlapInSubsystem(lineSegmentsMap);
        }
        if (this.checkForSignalAndBlockIntersection) {
            this.checkSubsystemForSignalAndBlockIntersection(subsystem, lineSegmentsMap);
        }
        if (this.checkForSplitOfSignalLines) {
            this.checkSubsystemForSplitOfSignalLines(subsystem, lineSegmentsMap);
        }
        if (this.checkForSlantLines) {
            this.checkForSlantLinesInBlock(subsystem, lineSegmentsMap);
        }
    }

    private void checkForSignalLineCrossingInSubsystem(Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        SetMap<Segment, SimulinkLine> segmentsToLineMap = SimulinkSignalAppearanceCheck.buildLinesPerSegmentMap(lineSegmentsMap);
        ArrayList segments = new ArrayList(segmentsToLineMap.getKeys());
        Collections.sort(segments);
        HashSet<SimulinkLine> linesToReport = new HashSet<SimulinkLine>();
        for (int i = 0; i < segments.size(); ++i) {
            for (int j = i + 1; j < segments.size(); ++j) {
                Segment s2;
                Segment s1 = (Segment)segments.get(i);
                if (SimulinkSignalAppearanceCheck.segmentsShareEndPoint(s1, s2 = (Segment)segments.get(j)) || SimulinkSignalAppearanceCheck.haveSameSlope(s1, s2) || !((Segment)segments.get(i)).asDoubleLine2D().intersectsLine(((Segment)segments.get(j)).asDoubleLine2D())) continue;
                SimulinkSignalAppearanceCheck.updateLinesToReportFindings(s1, s2, linesToReport, segmentsToLineMap, lineSegmentsMap);
            }
        }
        for (SimulinkLine line : linesToReport) {
            String message = SimulinkSignalAppearanceCheck.buildFindingMessage(line, "is horizontal or vertical and crosses another line");
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_SIGNAL_CROSSING).createAndStore();
        }
    }

    private static void updateLinesToReportFindings(Segment firstSegment, Segment secondSegment, Set<SimulinkLine> linesToReport, SetMap<Segment, SimulinkLine> segmentsToLineMap, Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        if (firstSegment.isHorizontalOrVertical()) {
            Set linesWithSegment1 = (Set)segmentsToLineMap.getCollection((Object)firstSegment);
            linesToReport.add(SimulinkSignalAppearanceCheck.selectOneFromLinesWithSameStart(linesWithSegment1, lineSegmentsMap));
        }
        if (secondSegment.isHorizontalOrVertical()) {
            Set linesWithSegment2 = (Set)segmentsToLineMap.getCollection((Object)secondSegment);
            linesToReport.add(SimulinkSignalAppearanceCheck.selectOneFromLinesWithSameStart(linesWithSegment2, lineSegmentsMap));
        }
    }

    private static boolean segmentsShareEndPoint(Segment s1, Segment s2) {
        HashSet<Point> points = new HashSet<Point>();
        points.add(s1.p1);
        points.add(s1.p2);
        points.add(s2.p1);
        points.add(s2.p2);
        if (points.size() < 4) {
            return true;
        }
        Line2D.Double s1Line = s1.asDoubleLine2D();
        if (s1Line.ptSegDist(s2.p1) < 0.1 || s1Line.ptSegDist(s2.p2) < 0.1) {
            return true;
        }
        Line2D.Double s2Line = s2.asDoubleLine2D();
        return s2Line.ptSegDist(s1.p1) < 0.1 || s2Line.ptSegDist(s1.p2) < 0.1;
    }

    private void checkForSignalLineOverlapInSubsystem(Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        SetMap<Segment, SimulinkLine> segmentsToLineMap = SimulinkSignalAppearanceCheck.buildLinesPerSegmentMap(lineSegmentsMap);
        ArrayList segments = new ArrayList(segmentsToLineMap.getKeys());
        Collections.sort(segments);
        HashSet<SimulinkLine> linesToReport = new HashSet<SimulinkLine>();
        for (int i = 0; i < segments.size(); ++i) {
            for (int j = i + 1; j < segments.size(); ++j) {
                Segment s2;
                Segment s1 = (Segment)segments.get(i);
                if (!SimulinkSignalAppearanceCheck.segmentsOverlap(s1, s2 = (Segment)segments.get(j))) continue;
                Set linesWithSegment1 = (Set)segmentsToLineMap.getCollection((Object)s1);
                linesToReport.add(SimulinkSignalAppearanceCheck.selectOneFromLinesWithSameStart(linesWithSegment1, lineSegmentsMap));
                Set linesWithSegment2 = (Set)segmentsToLineMap.getCollection((Object)s2);
                linesToReport.add(SimulinkSignalAppearanceCheck.selectOneFromLinesWithSameStart(linesWithSegment2, lineSegmentsMap));
            }
        }
        for (SimulinkLine line : linesToReport) {
            String message = SimulinkSignalAppearanceCheck.buildFindingMessage(line, "overlaps another line");
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_SIGNAL_CROSSING).createAndStore();
        }
    }

    private static boolean segmentsOverlap(Segment s1, Segment s2) {
        if (s1.p1.equals(s1.p2) || s2.p1.equals(s2.p2)) {
            return false;
        }
        int hits = 0;
        Line2D.Double s1Line = s1.asDoubleLine2D();
        Line2D.Double s2Line = s2.asDoubleLine2D();
        if (s1Line.ptSegDist(s2.p1) < 0.1) {
            ++hits;
        }
        if (s1Line.ptSegDist(s2.p2) < 0.1) {
            ++hits;
        }
        if (s2Line.ptSegDist(s1.p1) < 0.1) {
            ++hits;
        }
        if (s2Line.ptSegDist(s1.p2) < 0.1) {
            ++hits;
        }
        if (s1.p1.equals(s2.p1) || s1.p1.equals(s2.p2)) {
            --hits;
        }
        if (s1.p2.equals(s2.p1) || s1.p2.equals(s2.p2)) {
            --hits;
        }
        return hits >= 2;
    }

    private static boolean haveSameSlope(Segment s1, Segment s2) {
        double slope2;
        if (s1.isHorizontalSegment() && s2.isHorizontalSegment()) {
            return true;
        }
        if (s1.isVerticalSegment() && s2.isVerticalSegment()) {
            return true;
        }
        if (s1.isVerticalSegment() || s2.isVerticalSegment() || s1.isHorizontalSegment() || s2.isHorizontalSegment()) {
            return false;
        }
        double slope1 = SimulinkSignalAppearanceCheck.computeSlope(s1);
        return Math.abs(slope1 - (slope2 = SimulinkSignalAppearanceCheck.computeSlope(s2))) < 0.1;
    }

    private static double computeSlope(Segment segment) {
        CCSMAssert.isTrue((segment.p1.x != segment.p2.x ? 1 : 0) != 0, (String)"Can't compute slope of horizontal lines");
        return (double)(segment.p1.y - segment.p2.y) / (double)(segment.p1.x - segment.p2.x);
    }

    private void checkSubsystemForSignalAndBlockIntersection(SimulinkBlock subsystem, Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        UnmodifiableCollection linesInSubsystem = subsystem.getContainedLines();
        for (SimulinkBlock block : subsystem.getSubBlocks()) {
            Set linesNotConnectedToBlock = CollectionUtils.subtract((Collection)linesInSubsystem, (Collection)block.getOutLines());
            linesNotConnectedToBlock = CollectionUtils.subtract((Collection)linesNotConnectedToBlock, (Collection)block.getInLines());
            this.checkIfBlockAndLinesIntersect(block, linesNotConnectedToBlock, lineSegmentsMap);
        }
    }

    private void checkIfBlockAndLinesIntersect(SimulinkBlock block, Collection<SimulinkLine> lines, Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        Rectangle rectangle = block.obtainBlockLayoutData().getPosition();
        for (SimulinkLine line : lines) {
            List<Segment> segments = lineSegmentsMap.get(line);
            boolean intersection = false;
            for (Segment segment : segments) {
                if (!rectangle.intersectsLine(new Line2D.Double(segment.p1, segment.p2))) continue;
                intersection = true;
                break;
            }
            if (!intersection) continue;
            String message = MessageFormat.format(SIGNAL_CROSS_BLOCK_FINDING_MESSAGE_FORMAT, MarkupUtils.formatAsSourceCode((String)block.getNamePretty()));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_SIGNAL_CROSSES_BLOCK).createAndStore();
        }
    }

    private void checkSubsystemForSplitOfSignalLines(SimulinkBlock subsystem, Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        for (SimulinkBlock block : subsystem.getSubBlocks()) {
            for (SimulinkOutPort outport : block.getOutPorts()) {
                Set outLines = CollectionUtils.filterToSet((Collection)outport.getLines(), line -> line.getDstPort() != null);
                Set<SimulinkLine> linesToReport = SimulinkSignalAppearanceCheck.determineSimulinkLinesWithInvalidIntersections(lineSegmentsMap.entrySet().stream().filter(entry -> outLines.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                for (SimulinkLine lineToReport : linesToReport) {
                    String message = SimulinkSignalAppearanceCheck.buildFindingMessage(lineToReport, "splits into more than two sub lines at an intersection");
                    this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkLine(lineToReport)).addFindingProperties(RECOMMENDED_ACTION_SIGNAL_SPLIT_TO_SUBLINES).createAndStore();
                }
            }
        }
    }

    @VisibleForTesting
    public static Set<SimulinkLine> determineSimulinkLinesWithInvalidIntersections(Map<SimulinkLine, List<Segment>> lines) {
        if (lines.size() <= 2) {
            return Collections.emptySet();
        }
        SetMap<Segment, SimulinkLine> segmentsToLine = SimulinkSignalAppearanceCheck.buildLinesPerSegmentMap(lines);
        SetMap segmentsByStartPoint = new SetMap();
        for (Object segment : segmentsToLine.getKeys()) {
            segmentsByStartPoint.add((Object)((Segment)segment).p1, segment);
        }
        HashSet<Segment> segmentsToReport = new HashSet<Segment>();
        for (Map.Entry startPoint : segmentsByStartPoint.entrySet()) {
            if (((Set)startPoint.getValue()).size() <= 2) continue;
            segmentsToReport.add(SimulinkSignalAppearanceCheck.selectOneFromSegmentsWithSameStart((Set)startPoint.getValue()));
        }
        HashSet<SimulinkLine> linesToReport = new HashSet<SimulinkLine>();
        for (Segment segmentToReport : segmentsToReport) {
            linesToReport.add(SimulinkSignalAppearanceCheck.selectOneFromLinesWithSameStart((Set)segmentsToLine.getCollection((Object)segmentToReport), lines));
        }
        return linesToReport;
    }

    private static SetMap<Segment, SimulinkLine> buildLinesPerSegmentMap(Map<SimulinkLine, List<Segment>> lines) {
        SetMap segmentsPerLine = new SetMap();
        for (SimulinkLine line : lines.keySet()) {
            for (Segment segment : lines.get(line)) {
                segmentsPerLine.add((Object)segment, (Object)line);
            }
        }
        return segmentsPerLine;
    }

    private void checkForSlantLinesInBlock(SimulinkBlock block, Map<SimulinkLine, List<Segment>> lineSegmentsMap) {
        block0: for (SimulinkLine line : block.getContainedLines()) {
            for (Segment lineSegment : lineSegmentsMap.get(line)) {
                if (lineSegment.isHorizontalOrVertical()) continue;
                String message = SimulinkSignalAppearanceCheck.buildFindingMessage(line, "is drawn as a slanting line");
                this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_SLANT_LINE).createAndStore();
                continue block0;
            }
        }
    }

    private static Segment selectOneFromSegmentsWithSameStart(Set<Segment> segments) {
        double maxLength = Double.MIN_VALUE;
        Segment selected = null;
        for (Segment segment : segments) {
            double length = segment.p1.distance(segment.p2);
            if (!(length > maxLength)) continue;
            selected = segment;
            maxLength = length;
        }
        return selected;
    }

    private static SimulinkLine selectOneFromLinesWithSameStart(Set<SimulinkLine> lines, Map<SimulinkLine, List<Segment>> allLines) {
        Segment maxLastSegment = null;
        SimulinkLine selected = null;
        for (SimulinkLine line : lines) {
            List<Segment> segmentsOnLine = allLines.get(line);
            Segment lastSegment = segmentsOnLine.get(segmentsOnLine.size() - 1);
            if (maxLastSegment != null && lastSegment.compareTo(maxLastSegment) <= 0) continue;
            maxLastSegment = lastSegment;
            selected = line;
        }
        return selected;
    }

    private static String buildFindingMessage(SimulinkLine line, String findingMessageBody) {
        String sourceBlockName;
        Object lineDescription = "Line ";
        if (line.getSrcPort() != null && (sourceBlockName = line.getSrcPort().getBlock().getNamePretty()) != null && !sourceBlockName.isEmpty()) {
            lineDescription = (String)lineDescription + "from " + MarkupUtils.formatAsSourceCode((String)sourceBlockName) + " ";
        }
        return (String)lineDescription + findingMessageBody;
    }

    private static Map<SimulinkLine, List<Segment>> mapToSegments(Collection<SimulinkLine> lines) {
        HashMap<SimulinkLine, List<Segment>> segmentsPerLine = new HashMap<SimulinkLine, List<Segment>>();
        for (SimulinkLine line : lines) {
            List points = SimulinkLineLayoutUtils.extractLineLayoutData((SimulinkLine)line).getPoints();
            List<Segment> segments = SimulinkSignalAppearanceCheck.getSegmentsFromPoints(points);
            segmentsPerLine.put(line, segments);
        }
        return segmentsPerLine;
    }

    @VisibleForTesting
    public static List<Segment> getSegmentsFromPoints(List<Point> points) {
        if (points.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Point previousPoint = points.get(0);
        for (Point point : points.subList(1, points.size())) {
            segments.add(new Segment(previousPoint, point));
            previousPoint = point;
        }
        return segments;
    }

    @VisibleForTesting
    public static class Segment
    implements Comparable<Segment> {
        private final Point p1;
        private final Point p2;

        private Segment(Point p1, Point p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.p1.equals(segment.p1) && this.p2.equals(segment.p2);
        }

        public int hashCode() {
            return Objects.hash(this.p1, this.p2);
        }

        private boolean isHorizontalOrVertical() {
            return this.isHorizontalSegment() || this.isVerticalSegment();
        }

        private boolean isVerticalSegment() {
            return this.p1.x == this.p2.x || Math.abs(this.p1.x - this.p2.x) < 5;
        }

        private boolean isHorizontalSegment() {
            return this.p1.y == this.p2.y || Math.abs(this.p1.y - this.p2.y) < 5;
        }

        private Line2D.Double asDoubleLine2D() {
            return new Line2D.Double(this.p1, this.p2);
        }

        @Override
        public int compareTo(Segment otherSegment) {
            int result = this.p1.x - otherSegment.p1.x;
            if (result != 0) {
                return result;
            }
            result = this.p1.y - otherSegment.p1.y;
            if (result != 0) {
                return result;
            }
            result = this.p2.x - otherSegment.p2.x;
            if (result != 0) {
                return result;
            }
            result = this.p2.y - otherSegment.p2.y;
            return result;
        }
    }
}

