/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0004", languages={ELanguage.SIMULINK, ELanguage.MATLAB})
public class SimulinkMatlabWarningSuppressionCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_OK = FindingPropertyList.singleton((String)"Recommended Action", (String)"Specify all ignored messages IDs explicitly by adding them to the `%#ok` directive in angle brackets.");
    private static final FindingPropertyList RECOMMENDED_ACTION_CODEGEN = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add the `%#codegen` directive to the function definition.");
    private static final String DIRECTIVE_CODEGEN = "%#codegen";
    private static final String DIRECTIVE_PREFIX_IGNORE_WARNING = "%#ok";

    public void execute() throws CheckException {
        if (this.context.getLanguage() == ELanguage.MATLAB) {
            String script = this.context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT);
            this.checkScriptForUnqualifiedSuppressions(script, this.buildLocation().forElement());
            this.checkScriptForCodeGenCheckEnabled(script);
        } else if (ELanguage.SIMULINK == this.context.getLanguage() && this.context.getSimulinkContext().getSimulinkModelForModelFile().isPresent()) {
            SimulinkModel model = (SimulinkModel)this.context.getSimulinkContext().getSimulinkModelForModelFile().get();
            for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
                for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                    this.checkScriptForUnqualifiedSuppressions(script, (ElementLocation)this.context.buildLocation().forSimulinkBlock(block));
                }
            }
            for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
                String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
                this.checkScriptForUnqualifiedSuppressions(script, (ElementLocation)this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
            }
        }
    }

    private void checkScriptForUnqualifiedSuppressions(String script, ElementLocation forElement) {
        List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
        tokens.stream().filter(token -> token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT).filter(token -> token.getText().trim().startsWith(DIRECTIVE_PREFIX_IGNORE_WARNING)).filter(token -> !token.getText().matches("%#ok.*<.+>.*")).forEach(token -> {
            ElementLocation location = forElement instanceof QualifiedNameLocation ? forElement : (ElementLocation)this.buildLocation().forToken(token).orElseThrow();
            this.buildFinding("`#ok` comment does not specify message ID(s) in `" + token.getText() + "`", location).addFindingProperties(RECOMMENDED_ACTION_OK).createAndStore();
        });
    }

    private void checkScriptForCodeGenCheckEnabled(String script) {
        List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
        boolean hasCodeGenDirective = tokens.stream().filter(token -> token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT).anyMatch(token -> token.getText().trim().equals(DIRECTIVE_CODEGEN));
        if (!hasCodeGenDirective) {
            this.buildFinding("Directive `%#codegen` not found in the file with the external function definition", this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_CODEGEN).createAndStore();
        }
    }
}

