/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0201", languages={ELanguage.SIMULINK})
public class SimulinkDiscouragedCharactersInSubsystemNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the Subsystem block name so that it does not start with a digit or an underscore, end with an underscore, have more than one consecutive underscore or consist of either a restricted keyword or MATLAB function name.");
    private static final String FINDING_MESSAGE_INVALID_CHARACTERS = "Subsystem name shall contain only letters, digits, and underscores";
    private static final String FINDING_MESSAGE_STARTS_WITH_DIGIT = "Subsystem name starts with a digit";
    private static final String FINDING_MESSAGE_STARTS_WITH_UNDERSCORE = "Subsystem name starts with an underscore";
    private static final String FINDING_MESSAGE_ENDS_WITH_UNDERSCORE = "Subsystem name ends with an underscore";
    private static final String FINDING_MESSAGE_CONTAINS_CONSECUTIVE_UNDERSCORES = "Subsystem name contains consecutive underscores";
    private static final String FINDING_MESSAGE_RESERVED_KEYWORD = "Subsystem name is a reserved MATLAB keyword";
    private static final String FINDING_MESSAGE_FUNCTION_NAME = "Subsystem name is a MATLAB function name";
    @CheckOption(name="Disallow non-alphanumeric characters in subsystem names", description="If set, subsystem names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in subsystem names", description="If set, subsystem names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in subsystem names", description="If set, subsystem names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in subsystem names", description="If set, subsystem names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in subsystem names", description="If set, subsystem names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow subsystem names as reserved MATLAB keywords", description="If set, subsystem names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow subsystem names as MATLAB function names", description="If set, subsystem names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = true;
    @CheckOption(name="Whitelisted subsystem names", description="List of all subsystem names that are explicitly allowed, separated by a comma. These names are ignored by this check. Can be used to allow the usage of certain reserved keywords")
    private String whitelistedNames = "";
    @CheckOption(name="Check virtual subsystems", description="If set, virtual subsystems are also being checked.")
    private boolean checkVirtual = true;
    @CheckOption(name="Ignore hidden subsystem names", description="If set, hidden subsystem names are not checked.")
    private boolean ignoreHiddenSubsystemNames = false;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (this.ignoreBlock(block)) continue;
            this.checkIfNameIsValid(block);
        }
    }

    private void checkIfNameIsValid(SimulinkBlock block) {
        if (block.hasDefaultName()) {
            return;
        }
        Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName);
        List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(block.getName(), typesToCheck, this.whitelistedNames);
        for (ESimulinkNameCheckType failedCheck : failedChecks) {
            this.createFindingFromNameCheckType(block, failedCheck);
        }
    }

    private void createFindingFromNameCheckType(SimulinkBlock block, ESimulinkNameCheckType failedCheckType) {
        switch (failedCheckType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.buildFinding(FINDING_MESSAGE_INVALID_CHARACTERS, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.buildFinding(FINDING_MESSAGE_STARTS_WITH_DIGIT, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding(FINDING_MESSAGE_CONTAINS_CONSECUTIVE_UNDERSCORES, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding(FINDING_MESSAGE_STARTS_WITH_UNDERSCORE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding(FINDING_MESSAGE_ENDS_WITH_UNDERSCORE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding(FINDING_MESSAGE_FUNCTION_NAME, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding(FINDING_MESSAGE_RESERVED_KEYWORD, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
        }
    }

    private boolean ignoreBlock(SimulinkBlock block) {
        return !block.isOfSourceType("SubSystem") && !block.isOfType("SubSystem") || !this.checkVirtual && !SimulinkUtils.isNonVirtualSubsystem((SimulinkBlock)block) || this.ignoreHiddenSubsystemNames && !block.hasVisibleName();
    }
}

