/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.simulink.ESimulinkReservedNameType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0019", languages={ELanguage.SIMULINK})
public class SimulinkRestrictedVariableNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the variable name so that it is not identical to a reserved keyword.");
    @CheckOption(name="Whitelisted variable names", description="List of all variable names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)block)) continue;
            this.checkBlock(block);
        }
    }

    private void checkBlock(SimulinkBlock block) {
        for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
            List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
            List<String> variableNames = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ}).stream().map(matchingIndex -> ((IToken)tokens.get((int)matchingIndex)).getText()).collect(Collectors.toList());
            variableNames.addAll(SimulinkRestrictedVariableNamesCheck.extractVariableNamesAfterCaseStatements(tokens));
            variableNames.addAll(SimulinkRestrictedVariableNamesCheck.extractParameterNames(tokens));
            this.checkVariableNames(block, variableNames);
        }
    }

    private static List<String> extractVariableNamesAfterCaseStatements(List<IToken> tokens) {
        ArrayList<String> variableNames = new ArrayList<String>();
        int caseIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.CASE);
        while (caseIndex != -1) {
            int caseEnd = TokenStreamUtils.firstTokenMatching(tokens, (int)caseIndex, (ITokenMatcher)ETokenType.EOL);
            if (caseEnd == -1) {
                return variableNames;
            }
            List<IToken> caseTokens = tokens.subList(caseIndex, caseEnd);
            variableNames.addAll(caseTokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toList()));
            caseIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)caseEnd, (ITokenMatcher)ETokenType.CASE);
        }
        return variableNames;
    }

    private static List<String> extractParameterNames(List<IToken> tokens) {
        List parameterTokens = TokenStreamUtils.tokensBetween(tokens, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        return parameterTokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toList());
    }

    private void checkVariableNames(SimulinkBlock block, List<String> variableNames) {
        for (String variableName : variableNames) {
            ESimulinkReservedNameType nameType;
            if (this.whitelistedNames.contains(variableName) || ESimulinkReservedNameType.NON_RESERVED_NAME == (nameType = SimulinkNameChecker.getNameType(variableName))) continue;
            this.buildFinding("Name of variable " + MarkupUtils.formatAsSourceCode((String)variableName) + " conflicts with " + nameType.getName(), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

