/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0795", languages={ELanguage.SIMULINK})
public class SimulinkStateflowDataNameCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the data name so that it does not use underscores at the beginning or the end, contain consecutive underscores or consist merely of a Matlab keyword.");
    @CheckOption(name="Disallow non-alphanumeric characters in stateflow data names", description="If set, stateflow data names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in stateflow data names", description="If set, stateflow data names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in stateflow data names", description="If set, stateflow data names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in stateflow data names", description="If set, stateflow data names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in stateflow data names", description="If set, stateflow data names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow stateflow data names as reserved MATLAB keywords", description="If set, stateflow data names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow stateflow data names as MATLAB function names", description="If set, stateflow data names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = false;
    @CheckOption(name="Whitelisted stateflow data names", description="List of all stateflow data names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            StateflowChart chart = stateflowBlock.getChart();
            this.checkStateflowChart(chart, stateflowBlock);
        }
    }

    private void checkStateflowChart(StateflowChart chart, StateflowBlock block) {
        List dataNames = StateflowUtils.extractDataNames((UnmodifiableSet)chart.getData());
        for (String dataName : dataNames) {
            Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName);
            List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(dataName, typesToCheck, this.whitelistedNames);
            for (ESimulinkNameCheckType failedCheck : failedChecks) {
                this.createFindingFromNameCheckType(dataName, failedCheck, (SimulinkBlock)block);
            }
        }
    }

    private void createFindingFromNameCheckType(String dataName, ESimulinkNameCheckType failedCheckType, SimulinkBlock block) {
        String formattedDataName = MarkupUtils.formatAsSourceCode((String)dataName);
        switch (failedCheckType) {
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding(MessageFormat.format("Stateflow chart data name {0} shall not contain consecutive underscores", formattedDataName), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding(MessageFormat.format("Stateflow chart data name {0} shall not start with an underscore", formattedDataName), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding(MessageFormat.format("Stateflow chart data name {0} shall not end with an underscore", formattedDataName), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding(MessageFormat.format("Stateflow chart data name {0} shall not be a reserved MATLAB keyword", formattedDataName), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding(MessageFormat.format("Stateflow chart data name {0} shall not be a MATLAB function name", formattedDataName), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
        }
    }
}

