/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.SimulinkVariantConditionCheck;
import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.na_0036", languages={ELanguage.SIMULINK})
public class SimulinkDefaultVariantCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The variant subsystem has no default variant";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)("Add a variant with the Variant Control Expression " + MarkupUtils.formatAsSourceCode((String)"(default)")));
    private static final String FINDING_MESSAGE_ZERO_ACTIVE_VARIANT_CONTORLS = "Requirements for zero active variant controls are not fulfilled";
    private static final FindingPropertyList RECOMMENDED_ACTION_VARIANT_SUBSYSTEM = FindingPropertyList.singleton((String)"Recommended Action", (String)"Do the following to set the active variant as the default variant:\n1. Enable the option `Allow zero active variant controls` on the subsystem\n2. For each outport of the Variant subsystem,\n\t\t2.1. Enable the option `Specify output when source is unconnected`\n\t\t2.2. Provide a valid value for parameter `Constant value`\n\t\t2.3. Set parameter `Output Data type` to `Inherit: auto`");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (block.isOfType("VariantSource") || block.isOfType("VariantSink")) {
                this.checkVariantSourceAndSinkBlocks(model, block);
                continue;
            }
            if (!SimulinkUtils.isVariantSubsystem((SimulinkBlock)block)) continue;
            this.checkVariantSubsystem(block);
        }
    }

    private void checkVariantSourceAndSinkBlocks(SimulinkModel model, SimulinkBlock block) {
        Set<String> variantControlValues = Set.of(SimulinkVariantConditionCheck.getVariantControlValuesFromVariantSinkOrSourceBlock(model, block));
        if (variantControlValues.contains("(default)")) {
            return;
        }
        this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private void checkVariantSubsystem(SimulinkBlock subsystem) {
        Set variantControlValues = subsystem.getSubBlocks().stream().filter(block -> block.isOfType("SubSystem") || block.isOfType("ModelReference")).map(block -> block.getParameter("VariantControl")).collect(Collectors.toSet());
        if (variantControlValues.contains("(default)")) {
            return;
        }
        String allowZeroActiveVariantControls = subsystem.getParameter("AllowZeroVariantControls");
        if (!"on".equals(allowZeroActiveVariantControls)) {
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(subsystem)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        } else if (!SimulinkDefaultVariantCheck.satisfiesConditionsForZeroActiveVariants(subsystem)) {
            String message = MessageFormat.format(FINDING_MESSAGE_ZERO_ACTIVE_VARIANT_CONTORLS, MarkupUtils.formatAsSourceCode((String)subsystem.getName()));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(subsystem)).addFindingProperties(RECOMMENDED_ACTION_VARIANT_SUBSYSTEM).createAndStore();
        }
    }

    private static boolean satisfiesConditionsForZeroActiveVariants(SimulinkBlock subsystem) {
        for (SimulinkBlock block : subsystem.getSubBlocks()) {
            if (!SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            String outportWhenSourceIsUnconnected = block.getParameter("OutputWhenUnConnected");
            String outportConstantValue = block.getParameter("OutputWhenUnconnectedValue");
            String outportDataType = block.getParameter("OutDataTypeStr");
            if ("on".equals(outportWhenSourceIsUnconnected) && !StringUtils.isEmpty((String)outportConstantValue) && "Inherit: auto".equals(outportDataType)) continue;
            return false;
        }
        return true;
    }
}

