/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0081", languages={ELanguage.SIMULINK})
public class SimulinkInOutPortIconDisplayCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the Icon Display setting of Inport and Outport blocks to Port number.");

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, (Set)CollectionUtils.asHashSet((Object[])new String[]{"Inport", "Outport"}), (boolean)false, (boolean)false)) {
            this.checkBlockIconDisplay(block);
        }
    }

    private void checkBlockIconDisplay(SimulinkBlock block) {
        if (!block.getParameterNames().contains((Object)"IconDisplay")) {
            return;
        }
        String iconDisplayValue = block.getParameter("IconDisplay");
        if (!iconDisplayValue.equals("Port number")) {
            this.buildFinding("Icon Display setting is set to " + MarkupUtils.formatAsSourceCode((String)iconDisplayValue) + " instead of " + MarkupUtils.formatAsSourceCode((String)"Port number"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

