/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.na_0002", languages={ELanguage.SIMULINK})
public class SimulinkLogicalAndNumericalOperationsCheck
extends CheckImplementationBase {
    @CheckOption(name="Logical block types", description="The block types that perform logical operations. The given types apply to the 'type' property of simulink blocks or to the 'SourceType' property (for blocks of type Reference). See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> logicalBlocks = Set.of("EnablePort", "Logic", "TriggerPort");
    @CheckOption(name="Numerical block types", description="The block types that perform numerical operations. The given types apply to the 'type' property of simulink blocks or to the 'SourceType' property (for blocks of type Reference). See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> numericalBlocks = Set.of("Compare To Constant", "Compare To Zero", "ComplexToRealImag", "DotProduct", "Gain", "Product", "Slider Gain", "RelationalOperator", "Signum", "Sum");
    private static final String FINDING_MESSAGE_NUMERICAL_BLOCKS = "Numerical block performs logical operation with boolean data type as input";
    private static final String FINDING_MESSAGE_LOGICAL_BLOCKS = "Logical block performs numerical operation with non-boolean data type as input";
    private static final FindingPropertyList RECOMMENDED_ACTION_NUMERICAL_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use non-boolean inputs for numerical operation");
    private static final FindingPropertyList RECOMMENDED_ACTION_LOGICAL_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use boolean inputs for logical operation");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (resolvedTypes == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String type = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
            if (type != null && this.logicalBlocks.contains(type)) {
                this.checkLogicalBlock(block, resolvedTypes.getInputDataTypes(block));
                continue;
            }
            if (type != null && this.numericalBlocks.contains(type)) {
                this.checkNumericalBlock(block, resolvedTypes.getInputDataTypes(block));
                continue;
            }
            this.checkLogicalInPorts(block, resolvedTypes);
        }
    }

    private void checkLogicalInPorts(SimulinkBlock block, SimulinkResolvedDataTypes inputDataTypes) {
        block.getInPorts().stream().filter(port -> port.isEnablePort() || port.isTriggerPort()).forEach(port -> {
            String portInputDataType = inputDataTypes.getInputDataType(block, port.getIndex());
            if (!"boolean".equals(portInputDataType) && !"Unknown".equals(portInputDataType)) {
                this.buildFinding(FINDING_MESSAGE_LOGICAL_BLOCKS, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_LOGICAL_BLOCKS).createAndStore();
            }
        });
    }

    private void checkLogicalBlock(SimulinkBlock block, Set<String> inputDataTypes) {
        if (inputDataTypes.stream().anyMatch(type -> !"boolean".equals(type) && SimulinkLogicalAndNumericalOperationsCheck.isRelevantDataType(type))) {
            this.buildFinding(FINDING_MESSAGE_LOGICAL_BLOCKS, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_LOGICAL_BLOCKS).createAndStore();
        }
    }

    private void checkNumericalBlock(SimulinkBlock block, Set<String> inputDataTypes) {
        if (inputDataTypes.stream().anyMatch(type -> !"fixdt".equals(type) && !SimulinkDataTypeUtils.isNumericDataType((String)type) && SimulinkLogicalAndNumericalOperationsCheck.isRelevantDataType(type))) {
            this.buildFinding(FINDING_MESSAGE_NUMERICAL_BLOCKS, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NUMERICAL_BLOCKS).createAndStore();
        }
    }

    private static boolean isRelevantDataType(String type) {
        if (type == null) {
            return false;
        }
        switch (type) {
            case "Unknown": 
            case "NOT_CONNECTED": 
            case "enum": 
            case "Bus": {
                return false;
            }
        }
        return true;
    }
}

