/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0621", languages={ELanguage.SIMULINK})
public class SimulinkLogicalOperatorBlockShapeCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_SHAPE = "Logical operator block %s has no rectangular shape";
    private static final FindingPropertyList RECOMMENDED_ACTION_SHAPE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Logical operators shall have a rectangular icon shape.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!block.isOfType("Logic") || !"distinctive".equals(block.getDeclaredParameter("IconShape"))) continue;
            this.buildFinding(String.format(FINDING_MESSAGE_SHAPE, block.getName().replace("\\n", " ")), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SHAPE).createAndStore();
        }
    }
}

