/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Stack;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0015", languages={ELanguage.SIMULINK})
public class SimulinkMergeBlockUsageCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_UNCONDITIONAL_INPUT = "Block {0} connected to merge block is not a conditionally executed subsystem";
    private static final FindingPropertyList RECOMMENDED_ACTION_UNCONDITIONAL_INPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Make each input of the merge block a conditionally executed subsystem.");
    private static final String FINDING_MESSAGE_PARENT_IS_NON_VIRTUAL_SUBSYSTEM = "Merge block is located inside a non-virtual subsystem";
    private static final FindingPropertyList RECOMMENDED_ACTION_PARENT_IS_NON_VIRTUAL_SUBSYSTEM = FindingPropertyList.singleton((String)"Recommended Action", (String)"Make the parent of the merge block a virtual subsystem.");
    private static final String FINDING_MESSAGE_PORT_WIDTHS = "Parameter `Allow unequal port widths` must be turned `off`";
    private static final FindingPropertyList RECOMMENDED_ACTION_PORT_WIDTHS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the parameter `allow unequal port widths` of the merge block to `off`.");
    private static final String FINDING_MESSAGE_HELD_OUTPUTS = "The parameter `output when disabled` of the output block of the input subsystem shall be `%s` but is `%s`";
    private static final FindingPropertyList RECOMMENDED_ACTION_HELD_OUTPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the parameter `output when disabled` of the out block of each input subsystem to `held`.");
    private static final String FINDING_MESSAGE_SUBSYSTEM_EXECUTION = "Parameter `Detect multiple driving blocks executing at the same time step` must set to `error`";
    private static final FindingPropertyList RECOMMENDED_ACTION_SUBSYSTEM_EXECUTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the parameter `Detect multiple driving blocks executing at the same time step` of the merge block to `error`.");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkModel);
    }

    private void checkModel(SimulinkModel model) {
        if (!model.isLibraryModel()) {
            this.checkSubsystemsExecutionParameter((SimulinkBlock)model);
        }
        GotoFromResolver gotoFromResolver = model.getGotoFromResolver();
        for (SimulinkBlock mergeBlock : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Merge"), (boolean)false, (boolean)false)) {
            this.checkMergeBlockUsage(mergeBlock, gotoFromResolver);
        }
    }

    private void checkSubsystemsExecutionParameter(SimulinkBlock block) {
        String current = block.getParameter("MergeDetectMultiDrivingBlocksExec");
        if (!"error".equals(current)) {
            this.buildFinding(FINDING_MESSAGE_SUBSYSTEM_EXECUTION, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_EXECUTION).createAndStore();
        }
    }

    private void checkMergeBlockUsage(SimulinkBlock mergeBlock, GotoFromResolver gotoFromResolver) {
        this.checkPortWidthsParameter(mergeBlock);
        this.checkMergeBlockInputs(mergeBlock, gotoFromResolver);
        SimulinkBlock mergeBlockParent = mergeBlock.getParent();
        if (mergeBlockParent != null && SimulinkUtils.isSubsystem((SimulinkBlock)mergeBlockParent) && SimulinkUtils.isNonVirtualSubsystem((SimulinkBlock)mergeBlockParent)) {
            this.buildFinding(FINDING_MESSAGE_PARENT_IS_NON_VIRTUAL_SUBSYSTEM, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlockParent)).addFindingProperties(RECOMMENDED_ACTION_PARENT_IS_NON_VIRTUAL_SUBSYSTEM).createAndStore();
        }
    }

    private void checkPortWidthsParameter(SimulinkBlock mergeBlock) {
        String expected = "off";
        String current = mergeBlock.getParameter("AllowUnequalInputPortWidths");
        if (!expected.equals(current)) {
            this.buildFinding(FINDING_MESSAGE_PORT_WIDTHS, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_PORT_WIDTHS).createAndStore();
        }
    }

    private void checkMergeBlockInputs(SimulinkBlock mergeBlock, GotoFromResolver gotoFromResolver) {
        Stack<SimulinkInPort> inPorts = new Stack<SimulinkInPort>();
        inPorts.addAll((Collection<SimulinkInPort>)mergeBlock.getInPorts());
        while (!inPorts.isEmpty()) {
            SimulinkOutPort outPort;
            SimulinkInPort inPort = (SimulinkInPort)inPorts.pop();
            SimulinkLine line = inPort.getLine();
            if (line == null || (outPort = line.getSrcPort()) == null) continue;
            SimulinkBlock inputBlock = outPort.getBlock();
            if (SimulinkUtils.isFromBlock((SimulinkBlock)inputBlock)) {
                gotoFromResolver.getConnectedGotoBlocks(inputBlock).forEach(fromBlock -> inPorts.addAll((Collection<SimulinkInPort>)fromBlock.getInPorts()));
                continue;
            }
            if (SimulinkUtils.isInport((SimulinkBlock)inputBlock) && SimulinkUtils.isSubsystem((SimulinkBlock)inputBlock.getParent())) {
                inPorts.add(SimulinkUtils.getInportFromSubsystemInportBlock((SimulinkBlock)inputBlock));
                continue;
            }
            if (!SimulinkUtils.isSubsystem((SimulinkBlock)inputBlock)) continue;
            this.checkSubsystem(inputBlock, outPort);
        }
    }

    private void checkSubsystem(SimulinkBlock subsystem, SimulinkOutPort outPort) {
        if (!SimulinkUtils.isConditionalSubsystem((SimulinkBlock)subsystem)) {
            String findingMessage = MessageFormat.format(FINDING_MESSAGE_UNCONDITIONAL_INPUT, MarkupUtils.formatAsSourceCode((String)SimulinkBlock.replaceNewlines((String)subsystem.getNamePretty())));
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(subsystem)).addFindingProperties(RECOMMENDED_ACTION_UNCONDITIONAL_INPUT).createAndStore();
        } else {
            this.checkOutputHeldBackWhenDisabled(subsystem, outPort);
        }
    }

    private void checkOutputHeldBackWhenDisabled(SimulinkBlock subsystem, SimulinkOutPort outPort) {
        Optional outPortBlock = SimulinkUtils.findOutPortBlock((SimulinkBlock)subsystem, (String)outPort.getIndex());
        if (outPortBlock.isEmpty()) {
            return;
        }
        String expectedValue = "held";
        String currentValue = ((SimulinkBlock)outPortBlock.get()).getParameter("OutputWhenDisabled");
        if (!expectedValue.equals(currentValue)) {
            this.buildFinding(String.format(FINDING_MESSAGE_HELD_OUTPUTS, expectedValue, currentValue), (ElementLocation)this.buildLocation().forSimulinkBlock(subsystem)).addFindingProperties(RECOMMENDED_ACTION_HELD_OUTPUT).createAndStore();
        }
    }
}

