/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0081_line", languages={ELanguage.SIMULINK})
public class SimulinkUnconnectedLineCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect the line to a source or destination block, if known. Otherwise terminate the line using a ground or terminator block.");

    public void execute() {
        Optional model = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (model.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)model.get()), (boolean)false, (boolean)false)) {
            for (SimulinkLine line : block.getContainedLines()) {
                if (!SimulinkUtils.isUserVisible((SimulinkLine)line) || !line.hasUnconnectedEndpoint()) continue;
                this.buildFinding("Unconnected line", (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }
}

