/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0627", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck
extends CheckImplementationBase {
    private static final String NO_SATURATION_LIMITS_FINDING_MESSAGE = "The block does not have any Saturation limits set";
    private static final FindingPropertyList NO_SATURATION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider setting the Saturation limits by enabling the 'Limit output' checkbox.");
    private static final FindingPropertyList MISSING_SATURATION_LIMIT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider setting the data type of Saturation limit parameters to 'auto'.");
    private static final FindingPropertyList INF_SATURATION_LIMIT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider setting the Saturation limit to a finite value");
    private static final Set<String> INFINITY_VALUES = Set.of("inf", "-inf", "Infinity", "-Infinity");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        List<SimulinkDataDictionary> dictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!block.isOfType("DiscreteIntegrator")) continue;
            if (!SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.hasSaturationLimit(block)) {
                this.buildFinding(NO_SATURATION_LIMITS_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(NO_SATURATION_RECOMMENDED_ACTION).createAndStore();
                continue;
            }
            this.checkBlock(model, block, dictionaries);
        }
    }

    private static boolean hasSaturationLimit(SimulinkBlock block) {
        String limitOutput = block.getParameter("LimitOutput");
        return "on".equals(limitOutput);
    }

    private void checkBlock(SimulinkModel model, SimulinkBlock block, List<SimulinkDataDictionary> dictionaries) {
        this.checkSaturationLimit(model, block, dictionaries, "LowerSaturationLimit", true);
        this.checkSaturationLimit(model, block, dictionaries, "UpperSaturationLimit", false);
    }

    private void checkSaturationLimit(SimulinkModel model, SimulinkBlock block, List<SimulinkDataDictionary> dictionaries, String parameterName, boolean isLower) {
        String saturationLimit = block.getParameter(parameterName);
        if (!NumberUtils.isParsable((String)saturationLimit)) {
            if (SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.isInfinite(saturationLimit)) {
                this.createInfiniteLimitFinding(block, isLower);
            } else {
                this.checkSaturationLimitObject(model, block, saturationLimit, dictionaries, isLower);
            }
        }
    }

    private static boolean isInfinite(String saturationLimit) {
        return INFINITY_VALUES.contains(saturationLimit);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkSaturationLimitObject(SimulinkModel model, SimulinkBlock block, String objectName, List<SimulinkDataDictionary> dictionaries, boolean isLower) {
        Object object = SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.getObject(model, objectName, dictionaries);
        if (object instanceof SimulinkParameter) {
            SimulinkParameter simulinkParameter = (SimulinkParameter)object;
            if (SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.isInfinite(simulinkParameter.value)) {
                this.createInfiniteLimitFinding(block, isLower);
            }
            if (!SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.hasIncorrectType(simulinkParameter.getDataType())) return;
            this.createWrongDataTypeFinding(block, isLower);
            return;
        }
        if (object instanceof MatlabVariable) {
            MatlabVariable matlabVariable = (MatlabVariable)object;
            if (SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.isInfinite(matlabVariable.value)) {
                this.createInfiniteLimitFinding(block, isLower);
                return;
            }
        }
        if (!(object instanceof SimulinkObject)) return;
        SimulinkObject simulinkObject = (SimulinkObject)object;
        if (!SimulinkUsageOfDiscreteTimeIntegratorBlocksCheck.hasIncorrectType(simulinkObject.getParameter("type"))) return;
        this.createWrongDataTypeFinding(block, isLower);
    }

    private static Object getObject(SimulinkModel model, String objectName, List<SimulinkDataDictionary> dictionaries) {
        Optional entry = model.modelWorkspace.findEntry(objectName = objectName.replaceAll("[^A-Za-z0-9]", ""));
        if (entry.isPresent()) {
            return entry.get();
        }
        entry = SimulinkUtils.findDataDictionaryEntry(dictionaries, (String)objectName);
        if (entry.isPresent()) {
            return entry.get();
        }
        for (SimulinkObject object : model.getObjects()) {
            if (!objectName.equals(object.getName())) continue;
            return object;
        }
        return null;
    }

    private static boolean hasIncorrectType(String dataType) {
        return !"auto".equals(dataType);
    }

    private void createInfiniteLimitFinding(SimulinkBlock block, boolean isLower) {
        String part = isLower ? "lower" : "upper";
        String value = isLower ? "-inf" : "inf";
        String findingMessage = String.format("The %s Saturation limit is set to '%s'", part, value);
        this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(INF_SATURATION_LIMIT_RECOMMENDED_ACTION).createAndStore();
    }

    private void createWrongDataTypeFinding(SimulinkBlock block, boolean isLower) {
        String part = isLower ? "lower" : "upper";
        String findingMessage = String.format("The block does not have the recommended %s Saturation limit set", part);
        this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(MISSING_SATURATION_LIMIT_RECOMMENDED_ACTION).createAndStore();
    }
}

