/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0066", languages={ELanguage.SIMULINK}, phases={SimulinkFileReferencesPhase.class, SimulinkDataDictionaryLoadingPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUsageOfGainBlocksCheck
extends CheckImplementationBase {
    private static final String USAGE_OF_GAIN_BLOCK_FINDING_MESSAGE = "The value of a Gain block shall not resolve to 1";
    private static final FindingPropertyList USAGE_OF_GAIN_BLOCK_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remodel the Gain blocks so that the gain value does not resolve to 1, an identity matrix, or a matrix of ones.");
    private static final String SIMULINK_PARAMETER_AUTO_STORAGE_CLASS_NAME = "Auto";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Gain"), (boolean)false, (boolean)false)) {
            this.checkGainValueInBlock(model, dataDictionaries, block);
        }
    }

    private void checkGainValueInBlock(SimulinkModel model, List<SimulinkDataDictionary> dataDictionaries, SimulinkBlock block) {
        String gainValueString = block.getParameter("Gain");
        Optional entry = model.modelWorkspace.findEntry(gainValueString);
        if (entry.isPresent()) {
            if (entry.get() instanceof SimulinkParameter) {
                gainValueString = ((SimulinkParameter)entry.get()).value;
            } else if (entry.get() instanceof MatlabVariable) {
                gainValueString = ((MatlabVariable)entry.get()).value;
            }
        }
        for (SimulinkDataDictionary dictionary : dataDictionaries) {
            entry = dictionary.findEntry(gainValueString);
            if (!entry.isPresent()) continue;
            if (entry.get() instanceof SimulinkParameter) {
                if (!SIMULINK_PARAMETER_AUTO_STORAGE_CLASS_NAME.equals(((SimulinkParameter)entry.get()).storageClass)) {
                    return;
                }
                gainValueString = ((SimulinkParameter)entry.get()).value;
                break;
            }
            if (!(entry.get() instanceof MatlabVariable)) continue;
            gainValueString = ((MatlabVariable)entry.get()).value;
            break;
        }
        this.parseStringAndCheckValues(gainValueString, block);
    }

    private void parseStringAndCheckValues(String gainValueString, SimulinkBlock block) {
        gainValueString = gainValueString.replaceAll("[\\[\\]()]", "");
        String[] rows = gainValueString.split(";");
        ArrayList<List<Double>> matrixAsList = new ArrayList<List<Double>>();
        for (int i = 0; i < rows.length; ++i) {
            matrixAsList.add(new ArrayList());
            String row = rows[i].trim();
            String[] matrixCells = row.split("\\s+");
            if (gainValueString.contains(",")) {
                matrixCells = row.split(",");
            }
            for (String matrixCell : matrixCells) {
                try {
                    double value = Double.parseDouble(matrixCell.trim());
                    if (value != 0.0 && value != 1.0) {
                        return;
                    }
                    ((List)matrixAsList.get(i)).add(value);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
        }
        if (SimulinkUsageOfGainBlocksCheck.isIdentityMatrixOrMatrixOfOnes(matrixAsList)) {
            this.buildFinding(USAGE_OF_GAIN_BLOCK_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(USAGE_OF_GAIN_BLOCK_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean isIdentityMatrixOrMatrixOfOnes(List<List<Double>> matrix) {
        int oneRows = 0;
        for (int i = 0; i < matrix.size(); ++i) {
            List<Double> row = matrix.get(i);
            if (row.stream().allMatch(number -> number == 1.0)) {
                if (oneRows != i) {
                    return false;
                }
                ++oneRows;
                continue;
            }
            if (row.size() == 1 || matrix.size() == 1 || oneRows != 0) {
                return false;
            }
            for (Double value : row) {
                boolean isOneNotOnDiagonal;
                boolean isZeroOnDiagonal = value == 0.0 && row.indexOf(value) == i;
                boolean bl = isOneNotOnDiagonal = value == 1.0 && row.indexOf(value) != i;
                if (!(value > 1.0) && !(value < 0.0) && !isZeroOnDiagonal && !isOneNotOnDiagonal) continue;
                return false;
            }
        }
        return true;
    }
}

