/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0010a", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfIfBlocksCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "If block uses elseif but the else condition is missing";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use the else condition");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkModel);
    }

    private void checkModel(SimulinkBlock model) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String elseIfExpression;
            if (!"If".equals(block.getType()) || StringUtils.isEmpty((String)(elseIfExpression = block.getParameter("ElseIfExpressions"))) || block.getOutPorts().size() != 2) continue;
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

