/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.simulink.stateflow.EStateflowStateActionType;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0734", languages={ELanguage.SIMULINK})
public class SimulinkDistinctActionTypesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Combine the state actions such that each action type is present at most once for the block.");

    public void execute() {
        if (this.context.getSimulinkContext().getSimulinkModelForModelFile().isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)this.context.getSimulinkContext().getSimulinkModelForModelFile().get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowUtils.listStatesDepthFirst((StateflowChart)((StateflowBlock)block).getChart(), (boolean)false).forEach(this::checkStateflowState);
        }
    }

    private void checkStateflowState(StateflowState state) {
        List stateflowStateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state);
        HashSet stateActions = new HashSet();
        for (StateflowStateAction stateflowStateAction : stateflowStateActions) {
            List actionDeclarationTokens = stateflowStateAction.actionDeclaration;
            Set actionTypes = actionDeclarationTokens.stream().map(IToken::getText).map(EStateflowStateActionType::fromString).flatMap(Optional::stream).collect(Collectors.toSet());
            if (stateActions.add(actionTypes)) continue;
            this.buildFinding(String.format("Stateflow block contains the following action types more than once: %s", StringUtils.concat((Iterable)CollectionUtils.sort(actionTypes), (String)", ")), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

