/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.db_0132", languages={ELanguage.SIMULINK})
public class SimulinkOrientationOfTransitionsInFlowChartCheck
extends CheckImplementationBase {
    private static final String NON_HORIZONTAL_TRANSITION_WITH_CONDITION_FINDING_MESSAGE = "Conditional transition shall be drawn horizontally";
    private static final FindingPropertyList NON_HORIZONTAL_TRANSITION_WITH_CONDITION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Draw the transition horizontally");
    private static final String NON_VERTICAL_TRANSITION_WITH_CONDITION_ACTION_FINDING_MESSAGE = "Transition with condition actions shall be drawn vertically";
    private static final FindingPropertyList NON_VERTICAL_TRANSITION_WITH_CONDITION_ACTION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Draw the transition vertically");
    private static final String TRANSITION_WITH_CONDITION_EXPRESSION_AND_ACTION_FINDING_MESSAGE = "Transition shall not use condition expressions and conditions actions at the same time";
    private static final FindingPropertyList TRANSITION_WITH_CONDITION_EXPRESSION_AND_ACTION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Separate the condition expressions and conditions actions");
    private static final String TRANSITION_WITH_TRANSITION_ACTION_FINDING_MESSAGE = "Transition with transition action in Stateflow chart";
    private static final FindingPropertyList TRANSITION_WITH_TRANSITION_ACTION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Refactor the transition action of the transition");
    @CheckOption(name="Check for transition actions on Stateflow transitions", description="If this option is enabled, transition actions on Stateflow transitions will trigger findings (corresponds to MAAB db_0132_a).")
    private boolean checkForTransitionActions = true;
    @CheckOption(name="Check for orientation of Stateflow transitions", description="If this option is enabled, transition with condition actions must be vertical and transitions with condition expressions must be horizontal. Transitions with condition actions and condition expressions are not allowed (corresponds to MAAB db_0132_b).")
    private boolean checkForTransitionOrientation = true;

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        StateflowMachine machine = ((SimulinkModel)optionalSimulinkModel.get()).getStateflowMachine();
        if (machine == null) {
            return;
        }
        for (StateflowChart chart : machine.getCharts(false)) {
            for (IStateflowNodeContainer flowchart : StateflowUtils.listFlowCharts((StateflowChart)chart, (boolean)false)) {
                this.checkFlowChart(flowchart);
            }
        }
    }

    private void checkFlowChart(IStateflowNodeContainer<?> flowchart) {
        HashSet transitions = new HashSet();
        for (StateflowNodeBase node : flowchart.getNodes()) {
            transitions.addAll(node.getInTransitions());
            transitions.addAll(node.getOutTransitions());
        }
        for (StateflowTransition transition : transitions) {
            if (StateflowUtils.isCommented((ParameterizedElement)transition)) continue;
            if (this.checkForTransitionActions) {
                this.checkTransitionActionInTransition(transition);
            }
            if (!this.checkForTransitionOrientation) continue;
            this.checkOrientationOfTransition(transition);
        }
    }

    private void checkTransitionActionInTransition(StateflowTransition transition) {
        if (SimulinkOrientationOfTransitionsInFlowChartCheck.containsTransitionAction(transition)) {
            this.buildFinding(TRANSITION_WITH_TRANSITION_ACTION_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(TRANSITION_WITH_TRANSITION_ACTION_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean containsTransitionAction(StateflowTransition transition) {
        if (transition.getLabel() == null) {
            return false;
        }
        List labelTokens = ScannerUtils.getTokens((String)transition.getLabel(), (ELanguage)ELanguage.MATLAB, (String)transition.toString());
        int transitionActionStart = TokenStreamUtils.findFirstTopLevel((List)labelTokens, (ITokenMatcher)ETokenType.MATRIX_RIGHT_DIV, Arrays.asList(ETokenType.LBRACE, ETokenType.LBRACK), Arrays.asList(ETokenType.RBRACE, ETokenType.RBRACK));
        if (transitionActionStart == -1 || labelTokens.size() <= transitionActionStart + 1) {
            return false;
        }
        boolean startTokensLookLikeCComment = ((IToken)labelTokens.get(transitionActionStart + 1)).getType() == ETokenType.MATRIX_RIGHT_DIV && ((IToken)labelTokens.get(transitionActionStart)).getEndOffset() + 1 < ((IToken)labelTokens.get(transitionActionStart + 1)).getOffset();
        return !startTokensLookLikeCComment;
    }

    private void checkOrientationOfTransition(StateflowTransition transition) {
        boolean hasConditionExpression = SimulinkOrientationOfTransitionsInFlowChartCheck.hasConditionExpression(transition);
        boolean hasConditionAction = SimulinkOrientationOfTransitionsInFlowChartCheck.hasConditionAction(transition);
        if (hasConditionExpression && hasConditionAction) {
            this.buildFinding(TRANSITION_WITH_CONDITION_EXPRESSION_AND_ACTION_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(TRANSITION_WITH_CONDITION_EXPRESSION_AND_ACTION_RECOMMENDED_ACTION).createAndStore();
        } else {
            TransitionLayoutData transitionLayoutData = transition.obtainLayoutData();
            if (hasConditionExpression && !StateflowUtils.isHorizontalTransition((TransitionLayoutData)transitionLayoutData) && transition.getSrc() != null && !StateflowUtils.isInsideLoop((StateflowNodeBase)transition.getSrc())) {
                this.buildFinding(NON_HORIZONTAL_TRANSITION_WITH_CONDITION_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(NON_HORIZONTAL_TRANSITION_WITH_CONDITION_RECOMMENDED_ACTION).createAndStore();
            } else if (hasConditionAction && !StateflowUtils.isVerticalTransition((TransitionLayoutData)transitionLayoutData) && transition.getSrc() != null && !StateflowUtils.isInsideLoop((StateflowNodeBase)transition.getSrc())) {
                this.buildFinding(NON_VERTICAL_TRANSITION_WITH_CONDITION_ACTION_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(NON_VERTICAL_TRANSITION_WITH_CONDITION_ACTION_RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private static boolean hasConditionExpression(StateflowTransition transition) {
        String label = transition.getLabel();
        if (label == null) {
            return false;
        }
        int bracketIndex = label.indexOf("{");
        int braceIndex = label.indexOf("[");
        return braceIndex != -1 && (bracketIndex == -1 || braceIndex < bracketIndex);
    }

    private static boolean hasConditionAction(StateflowTransition transition) {
        String label = transition.getLabel();
        if (label == null || !label.contains("{")) {
            return false;
        }
        int braceIndex = label.indexOf("{");
        boolean hasPrefixedSlash = SimulinkOrientationOfTransitionsInFlowChartCheck.hasPrefixedSlash(label, braceIndex);
        return !hasPrefixedSlash;
    }

    private static boolean hasPrefixedSlash(String transitionLabel, int characterIndex) {
        return characterIndex > 0 && transitionLabel.charAt(characterIndex - 1) == '/';
    }
}

