/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0511", languages={ELanguage.SIMULINK})
public class SimulinkReturnValueOfStateflowGraphicalFunctionCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the value in only one transition in the graphical function.");
    private static final Pattern ACTION_PATTERN = Pattern.compile("\\{(.*)\\}");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!block.isOfType("SubSystem") || !(block instanceof StateflowBlock)) continue;
            this.checkGraphicalFunctionsInStateflowBlock((StateflowBlock)block);
        }
    }

    private void checkGraphicalFunctionsInStateflowBlock(StateflowBlock block) {
        List<StateflowState> graphicalFunctions = SimulinkReturnValueOfStateflowGraphicalFunctionCheck.extractGraphicalFunctions(block);
        for (StateflowState graphicalFunction : graphicalFunctions) {
            CounterSet<String> returnVarAssignments = SimulinkReturnValueOfStateflowGraphicalFunctionCheck.countReturnVarAssignments(graphicalFunction);
            for (String returnVar : returnVarAssignments.getKeys()) {
                if (returnVarAssignments.getValue((Object)returnVar) <= 1) continue;
                this.buildFinding("Return value " + MarkupUtils.formatAsSourceCode((String)returnVar) + " of graphical function is assigned multiple times", (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)graphicalFunction)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private static CounterSet<String> countReturnVarAssignments(StateflowState graphicalFunction) {
        String signature = graphicalFunction.getParameter("labelString");
        Set<String> returnVariables = SimulinkReturnValueOfStateflowGraphicalFunctionCheck.extractReturnVariablesFromSignature(signature);
        CounterSet returnVarAssignments = new CounterSet();
        for (StateflowNodeBase subNode : graphicalFunction.getNodes()) {
            for (StateflowTransition transition : subNode.getInTransitions()) {
                String transitionLabel = transition.getParameter("labelString");
                for (String varAssignedInNode : SimulinkReturnValueOfStateflowGraphicalFunctionCheck.extractAssignedVariablesFromLabel(transitionLabel)) {
                    if (!returnVariables.contains(varAssignedInNode)) continue;
                    returnVarAssignments.inc((Object)varAssignedInNode);
                }
            }
        }
        return returnVarAssignments;
    }

    private static Set<String> extractAssignedVariablesFromLabel(String labelString) {
        if (labelString == null) {
            return Collections.emptySet();
        }
        HashSet<String> assignedVariables = new HashSet<String>();
        Matcher actionPatternMatcher = ACTION_PATTERN.matcher(labelString);
        while (actionPatternMatcher.find()) {
            String action = actionPatternMatcher.group(1);
            assignedVariables.addAll(SimulinkReturnValueOfStateflowGraphicalFunctionCheck.extractAssignedVariableNames(action));
        }
        return assignedVariables;
    }

    private static Set<String> extractReturnVariablesFromSignature(String signature) {
        if (signature == null) {
            return Collections.emptySet();
        }
        signature = signature.trim();
        return SimulinkReturnValueOfStateflowGraphicalFunctionCheck.extractAssignedVariableNames(signature);
    }

    private static Set<String> extractAssignedVariableNames(String statement) {
        int returnVarEnd = statement.indexOf("=");
        if (returnVarEnd == -1) {
            return Collections.emptySet();
        }
        if ((statement = statement.substring(0, returnVarEnd)).startsWith("[")) {
            int returnVarsEnd = statement.indexOf("]");
            if (returnVarsEnd == -1) {
                return Collections.emptySet();
            }
            Object[] returnVars = statement.substring(1, returnVarsEnd).split(",");
            for (int i = 0; i < returnVars.length; ++i) {
                returnVars[i] = ((String)returnVars[i]).trim();
            }
            return CollectionUtils.asHashSet((Object[])returnVars);
        }
        return Collections.singleton(statement.substring(0, returnVarEnd).trim());
    }

    private static List<StateflowState> extractGraphicalFunctions(StateflowBlock stateflowBlock) {
        ArrayList<StateflowState> graphicalFunctions = new ArrayList<StateflowState>();
        List nodes = StateflowUtils.listNodesRecursively((StateflowChart)stateflowBlock.getChart(), (boolean)false);
        for (StateflowNodeBase node : nodes) {
            UnmodifiableSet subNodes;
            if (!node.getParameter("type").equals("FUNC_STATE") || !(node instanceof StateflowState) || (subNodes = ((StateflowState)node).getNodes()).isEmpty() || !subNodes.stream().anyMatch(n -> n.getParameter("type").equals("CONNECTIVE_JUNCTION"))) continue;
            graphicalFunctions.add((StateflowState)node);
        }
        return graphicalFunctions;
    }
}

