/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import com.google.common.collect.Ordering;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.simulink.stateflow.EStateflowStateActionType;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0733", languages={ELanguage.SIMULINK})
public class SimulinkStateflowOrderOfActionTypesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Rearrange the state action types in the following order: entry (en), during (du), exit (ex).");
    private static final String BASIC_ACTION_TYPES_FINDING_MESSAGE = "Stateflow state contains basic state action types in the wrong order";
    private static final String COMBINED_ACTION_TYPES_FINDING_MESSAGE = "Stateflow state contains combined state action types in the wrong order";
    @CheckOption(name="Check combined state actions", description="If this option is enabled, combined state actions will also be checked for correct order (corresponds to MAAB jc_0733_b).")
    private boolean checkCombinedActionTypes = true;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
                if (!(node instanceof StateflowState)) continue;
                this.checkStateflowState((StateflowState)node);
            }
        }
    }

    private void checkStateflowState(StateflowState state) {
        List stateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state);
        ArrayList<String> identifiers = new ArrayList<String>();
        for (StateflowStateAction action : stateActions) {
            List actionDeclarations = action.actionDeclaration;
            List<String> actionNames = actionDeclarations.stream().map(IToken::getText).collect(Collectors.toList());
            if (actionNames.stream().noneMatch(StateflowStateAction.BASIC_STATEFLOW_STATE_ACTION_TYPES::contains)) continue;
            if (actionDeclarations.size() > 1 && this.checkCombinedActionTypes) {
                this.checkStateActionOrders(actionNames, state, COMBINED_ACTION_TYPES_FINDING_MESSAGE);
            }
            identifiers.add(SimulinkStateflowOrderOfActionTypesCheck.getLowestBasicActionType(actionNames));
        }
        this.checkStateActionOrders(identifiers, state, BASIC_ACTION_TYPES_FINDING_MESSAGE);
    }

    private static String getLowestBasicActionType(List<String> actionDeclarations) {
        if (actionDeclarations.size() == 1) {
            return actionDeclarations.get(0);
        }
        if (actionDeclarations.contains("ex") || actionDeclarations.contains("exit")) {
            return "ex";
        }
        if (actionDeclarations.contains("du") || actionDeclarations.contains("during")) {
            return "du";
        }
        return "en";
    }

    private void checkStateActionOrders(List<String> stateActions, StateflowState state, String findingsMessage) {
        List actionTypes = stateActions.stream().map(EStateflowStateActionType::fromString).flatMap(Optional::stream).collect(Collectors.toList());
        if (!Ordering.natural().isOrdered(actionTypes)) {
            this.buildFinding(findingsMessage, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

