/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0774", languages={ELanguage.SIMULINK})
public class SimulinkStateflowTransitionCommentsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add a condition or an action to the transition, or a clarification comment why the former two are missing");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
                if (node.getOutTransitions().size() < 2) continue;
                List violatingTransitions = CollectionUtils.filter((Collection)node.getOutTransitions(), transition -> StringUtils.isEmpty((String)transition.getLabel()) && !StateflowUtils.isCommented((ParameterizedElement)transition));
                for (StateflowTransition transition2 : violatingTransitions) {
                    this.buildFinding("No clarification comment provided for transition that has no condition nor action", (ElementLocation)this.buildLocation().forStateflowTransition(transition2)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                }
            }
        }
    }
}

