/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.db_0122", languages={ELanguage.SIMULINK})
public class SimulinkStrongTypingInChartsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Enable the *Use Strong Data Typing with Simulink I/O* option for this chart.");
    private static final String STRONG_TYPING_OPTION_NAME = "disableImplicitCasting";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            StateflowChart chart;
            String strongTypingOptionValue;
            if (!block.isOfType("SubSystem") || !(block instanceof StateflowBlock) || "1".equals(strongTypingOptionValue = (chart = ((StateflowBlock)block).getChart()).getParameter(STRONG_TYPING_OPTION_NAME))) continue;
            this.buildFinding("Stateflow chart without strong data typing", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

