/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jspecify.annotations.Nullable;

@Check(id="cqse.hism.hisf_0064", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUsageOfShiftOperationsInStateflowDataCheck
extends CheckImplementationBase {
    private static final String INVALID_RIGHT_SHIFT_FINDING_MESSAGE = "Right-shift operation shall not be greater than the bit-width of the input type";
    private static final String INVALID_LEFT_SHIFT_FINDING_MESSAGE = "Left-shift operation shall not be greater than the bit-width of the output type";
    private static final String NEGATIVE_SHIFT_FINDING_MESSAGE = "Shift operand shall not have a negative value";
    public static final String MATLAB_BITSHIFT_KEYWORD = "bitshift";
    private static final FindingPropertyList INVALID_RIGHT_SHIFT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the value of the bit-shift operation to be less than the bit-width of the input type.");
    private static final FindingPropertyList INVALID_LEFT_SHIFT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the value of the bit-shift operation to be less than the bit-width of the output type.");
    private static final FindingPropertyList NEGATIVE_SHIFT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the value of the bit-shift operation to be positive.");
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes simulinkTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || simulinkTypes == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            this.checkTransitionsForInvalidShifts(chart, simulinkTypes, dataDictionaries);
            this.checkNodesForInvalidShifts(chart, simulinkTypes, dataDictionaries);
        }
    }

    private void checkTransitionsForInvalidShifts(StateflowChart chart, SimulinkResolvedDataTypes simulinkTypes, List<SimulinkDataDictionary> dataDictionaries) {
        for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
            StateflowTransitionParts transitionLabelParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            QualifiedNameLocation location = this.buildLocation().forStateflowTransition(transition);
            if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
                StateflowVariableTypeExtractor stateflowTypes = new StateflowVariableTypeExtractor(simulinkTypes);
                this.checkForInvalidShiftsInC(transitionLabelParts.conditionAction, chart, stateflowTypes, location);
                this.checkForInvalidShiftsInC(transitionLabelParts.transitionAction, chart, stateflowTypes, location);
                continue;
            }
            try {
                this.checkForInvalidShiftsInMatlab(MatlabActionTypeResolver.from((List)transitionLabelParts.conditionAction, (StateflowTransition)transition, (SimulinkResolvedDataTypes)simulinkTypes, dataDictionaries), location);
            }
            catch (MatlabActionParserException e) {
                LOGGER.debug("Could not parse code in " + location.getQualifiedName(), (Throwable)e);
            }
            try {
                this.checkForInvalidShiftsInMatlab(MatlabActionTypeResolver.from((List)transitionLabelParts.transitionAction, (StateflowTransition)transition, (SimulinkResolvedDataTypes)simulinkTypes, dataDictionaries), location);
            }
            catch (MatlabActionParserException e) {
                LOGGER.debug("Could not parse code in " + location.getQualifiedName(), (Throwable)e);
            }
        }
    }

    private void checkNodesForInvalidShifts(StateflowChart chart, SimulinkResolvedDataTypes simulinkTypes, List<SimulinkDataDictionary> dataDictionaries) {
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
            for (StateflowStateAction stateAction : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
                QualifiedNameLocation location = this.buildLocation().forStateflowNode((StateflowNodeBase)state);
                if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
                    StateflowVariableTypeExtractor stateflowTypes = new StateflowVariableTypeExtractor(simulinkTypes);
                    this.checkForInvalidShiftsInC(stateAction.actionCode, chart, stateflowTypes, location);
                    continue;
                }
                try {
                    this.checkForInvalidShiftsInMatlab(MatlabActionTypeResolver.from((List)stateAction.actionCode, (StateflowState)state, (SimulinkResolvedDataTypes)simulinkTypes, dataDictionaries), location);
                }
                catch (MatlabActionParserException e) {
                    LOGGER.debug("Could not parse code in " + location.getQualifiedName(), (Throwable)e);
                }
            }
        }
    }

    private void checkForInvalidShiftsInC(List<IToken> tokens, StateflowChart chart, StateflowVariableTypeExtractor stateflowTypes, QualifiedNameLocation location) {
        List statementsTokens = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ETokenType.SEMICOLON});
        if (statementsTokens.stream().anyMatch(statementTokens -> CShiftPatterns.hasLeftShiftError(statementTokens, chart, stateflowTypes))) {
            this.createLeftShiftFinding(location);
        }
        if (statementsTokens.stream().anyMatch(statementTokens -> CShiftPatterns.hasRightShiftError(statementTokens, chart, stateflowTypes))) {
            this.createRightShiftFinding(location);
        }
        if (statementsTokens.stream().anyMatch(CShiftPatterns::hasNegativeShiftError)) {
            this.buildFinding(NEGATIVE_SHIFT_FINDING_MESSAGE, (ElementLocation)location).addFindingProperties(NEGATIVE_SHIFT_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkForInvalidShiftsInMatlab(MatlabActionTypeResolver typeResolver, QualifiedNameLocation location) {
        List bitshiftFunctions = MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)typeResolver.getRootNode(), (EMatlabActionEntityType[])new EMatlabActionEntityType[]{EMatlabActionEntityType.FUNCTION}).stream().filter(function -> ((IToken)function.getTokens().get(0)).getText().equals(MATLAB_BITSHIFT_KEYWORD)).collect(Collectors.toList());
        boolean hasLeftShiftError = false;
        boolean hasRightShiftError = false;
        for (MatlabActionAstNode bitshiftFunction : bitshiftFunctions) {
            MatlabActionAstNode shiftedVariableNode = (MatlabActionAstNode)bitshiftFunction.getChildren().get(0);
            MatlabActionAstNode shiftValueNode = (MatlabActionAstNode)bitshiftFunction.getChildren().get(1);
            Integer shiftValue = SimulinkUsageOfShiftOperationsInStateflowDataCheck.parseShiftValue(shiftValueNode);
            if (shiftValue == null) continue;
            if (shiftValue < 0) {
                if (SimulinkUsageOfShiftOperationsInStateflowDataCheck.getBitWidthFromDataType(typeResolver.inferDataTypeOf(shiftedVariableNode)) >= Math.abs(shiftValue)) continue;
                hasRightShiftError = true;
                continue;
            }
            MatlabActionAstNode assignmentNode = (MatlabActionAstNode)MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)typeResolver.getRootNode(), (EMatlabActionEntityType[])new EMatlabActionEntityType[]{EMatlabActionEntityType.ASSIGNMENT}).get(0);
            String outVar = ((IToken)((MatlabActionAstNode)assignmentNode.getChildren().get(0)).getTokens().get(0)).getText();
            if (SimulinkUsageOfShiftOperationsInStateflowDataCheck.getBitWidthFromDataType(typeResolver.inferDataTypeOf(outVar)) >= shiftValue) continue;
            hasLeftShiftError = true;
        }
        if (hasLeftShiftError) {
            this.createLeftShiftFinding(location);
        }
        if (hasRightShiftError) {
            this.createRightShiftFinding(location);
        }
    }

    private static @Nullable Integer parseShiftValue(MatlabActionAstNode shiftValueNode) {
        String valueString = shiftValueNode.getTokens().stream().map(IToken::getText).collect(Collectors.joining(""));
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void createLeftShiftFinding(QualifiedNameLocation location) {
        this.buildFinding(INVALID_LEFT_SHIFT_FINDING_MESSAGE, (ElementLocation)location).addFindingProperties(INVALID_LEFT_SHIFT_RECOMMENDED_ACTION).createAndStore();
    }

    private void createRightShiftFinding(QualifiedNameLocation location) {
        this.buildFinding(INVALID_RIGHT_SHIFT_FINDING_MESSAGE, (ElementLocation)location).addFindingProperties(INVALID_RIGHT_SHIFT_RECOMMENDED_ACTION).createAndStore();
    }

    private static int getBitWidthFromDataType(String dataType) {
        switch (dataType) {
            case "Unknown": 
            case "NOT_CONNECTED": 
            case "double": {
                return 64;
            }
            case "single": {
                return 32;
            }
        }
        return Integer.parseInt(dataType.replaceAll("[^\\d.]", ""));
    }

    private static class CShiftPatterns {
        private static final ETokenType[][] LEFT_SHIFT_PATTERNS = new ETokenType[][]{{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.LSHIFT, ETokenType.INTEGER_LITERAL}, {ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.MINUS, ETokenType.IDENTIFIER, ETokenType.LSHIFT, ETokenType.INTEGER_LITERAL}};
        private static final ETokenType[][] RIGHT_SHIFT_PATTERNS = new ETokenType[][]{{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.GT, ETokenType.GT, ETokenType.INTEGER_LITERAL}, {ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.MINUS, ETokenType.IDENTIFIER, ETokenType.GT, ETokenType.GT, ETokenType.INTEGER_LITERAL}};
        private static final ETokenType[][] NEGATIVE_SHIFT_PATTERNS = new ETokenType[][]{{ETokenType.IDENTIFIER, ETokenType.LSHIFT, ETokenType.MINUS, ETokenType.INTEGER_LITERAL}, {ETokenType.IDENTIFIER, ETokenType.GT, ETokenType.GT, ETokenType.MINUS, ETokenType.INTEGER_LITERAL}};
        private static final ETokenType[] INPUT_VARIABLE_PATTERN = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.GT, ETokenType.GT};
        private static final ETokenType[] OUTPUT_VARIABLE_PATTERN = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ};

        private CShiftPatterns() {
        }

        private static boolean hasLeftShiftError(List<IToken> tokens, StateflowChart chart, StateflowVariableTypeExtractor types) {
            return CShiftPatterns.hasShiftError(tokens, chart, types, LEFT_SHIFT_PATTERNS, OUTPUT_VARIABLE_PATTERN);
        }

        private static boolean hasRightShiftError(List<IToken> tokens, StateflowChart chart, StateflowVariableTypeExtractor types) {
            return CShiftPatterns.hasShiftError(tokens, chart, types, RIGHT_SHIFT_PATTERNS, INPUT_VARIABLE_PATTERN);
        }

        private static boolean hasShiftError(List<IToken> tokens, StateflowChart chart, StateflowVariableTypeExtractor types, ETokenType[][] shiftPatterns, ETokenType[] inputVariablePattern) {
            for (ETokenType[] shiftPattern : shiftPatterns) {
                List<Integer> shiftIndices = CShiftPatterns.findShiftPatternMatches(tokens, shiftPattern);
                for (int shiftExpressionStart : shiftIndices) {
                    List<IToken> matchedTokens = tokens.subList(shiftExpressionStart, shiftExpressionStart + shiftPattern.length);
                    String dataType = CShiftPatterns.determineDataType(matchedTokens, chart, types, inputVariablePattern);
                    if (dataType == null || SimulinkUsageOfShiftOperationsInStateflowDataCheck.getBitWidthFromDataType(dataType) >= CShiftPatterns.getShiftValue(matchedTokens)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean hasNegativeShiftError(List<IToken> tokens) {
            for (ETokenType[] shiftPattern : NEGATIVE_SHIFT_PATTERNS) {
                List<Integer> shiftIndices = CShiftPatterns.findShiftPatternMatches(tokens, shiftPattern);
                if (shiftIndices.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private static List<Integer> findShiftPatternMatches(List<IToken> tokens, ETokenType[] shiftPattern) {
            return TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])shiftPattern);
        }

        private static @Nullable String determineDataType(List<IToken> matchedTokens, StateflowChart chart, StateflowVariableTypeExtractor types, ETokenType[] variablePattern) {
            int identifierIndex = TokenStreamUtils.firstTokenOfTypeSequence(matchedTokens, (int)0, (ETokenType[])variablePattern);
            if (identifierIndex == -1) {
                return null;
            }
            String identifierName = matchedTokens.get(identifierIndex).getText();
            return types.determineType(identifierName, (StateflowDeclContainerBase)chart);
        }

        private static int getShiftValue(List<IToken> matchedTokens) {
            return Integer.parseInt(matchedTokens.get(matchedTokens.size() - 1).getText());
        }
    }
}

