/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="cqse-search-imperative-control-structures", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SearchImperativeControlStructuresCheck
extends CheckImplementationBase {
    private static final Set<String> TARGET_SUBTYPES = Set.of("if", "while", "for");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TARGET_SUBTYPES.contains(statement.getSubtype())) continue;
            this.buildFinding(this.buildFindingMessage(statement), this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private String buildFindingMessage(ShallowEntity entity) {
        return "Imperative control structure found: '" + entity.getSubtype().toUpperCase() + "'";
    }
}

