/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedMultiMapRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-avoid-symbols", languages={ELanguage.NL_TESTS, ELanguage.NL_REQUIREMENTS})
public class AvoidSymbolCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Avoid Symbols";
    @CheckOption(name="Avoid Symbols - Rules", description="List of required avoid symbol rules separated by comma or new-line.\nA single avoid symbol rule has the format:\n\n`<itemType> -> <fieldNames>:<prohibitedSymbols>:<exceptions>`\n\n`<itemType>` can be any type of item (e.g. `Requirement`, `Test Case`, `Manual Test Case`, etc...) or also their abbreviations (e.g `REG`, `TC`, `MTC`, etc...)\n\n`<fieldNames>` is a `|` separated list of fields which should not contain the following symbols (e.g. `Acceptance Criteria` or `Description`).\nAn empty list means that all all the symbols should be avoided in all fields.\n\n`<prohibitedSymbols>` is a string of the symbols to avoid (e.g. `{}` or `!`).\n\n`<exceptions>` is a regex of exceptions for the symbols preceding the ':' separator\n\nHere are some example rules:\n\n`ANY -> ALL:/[]():` implies that all fields for all spec item types should not contain any of the symbols: `/`,`[`,`]`,`(`,`)`.\n\n`Test Case -> Description:/:km/h` implies that the field 'Description' of an item type 'Test Case' should not include a `/` except for the usage of the measuring unit \"km/h\".\n\n`Test Case -> Description:/:k?m/([sh]|min)` implies that the field 'Description' of an item type 'Test Case' should not include a `/` except for the usage of the measuring units in the scope of the regex.\n\n`Feature -> Acceptance Criteria|Description:{:` implies that the fields 'Acceptance Criteria' and 'Description' of a 'Feature' must not contain a `{`.\n\n`Feature -> Acceptance Criteria|Description:{}:` implies that the fields 'Acceptance Criteria' and 'Description' of a 'Feature' must not contain a `{` or a `}`.\n", multilineText=true)
    private Set<String> rawAvoidSymbolsRules = Collections.singleton("ANY -> ALL:/:k?m/(s|h|m(in)?)");
    private final Set<TypedMultiMapRule<String, Pair<String, String>>> parsedAvoidSymbolRules = new HashSet<TypedMultiMapRule<String, Pair<String, String>>>();
    private static final TypedMultiMapRule.Parser<String, Pair<String, String>> PARSER = new TypedMultiMapRule.Parser().withKeyParser(ParsableRule.RuleParser.TO_STRING).withValueParser(str -> {
        String[] split = str.split(":", 2);
        if (split.length > 1) {
            return new Pair((Object)split[0], (Object)split[1]);
        }
        return new Pair((Object)split[0], (Object)"");
    });

    public AvoidSymbolCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        for (String rawAvoidSymbolRule : this.rawAvoidSymbolsRules) {
            this.parsedAvoidSymbolRules.add((TypedMultiMapRule<String, Pair<String, String>>)PARSER.parse(rawAvoidSymbolRule));
        }
    }

    @Override
    public void execute(SpecItem item) throws CheckException {
        WorkItemDescriberBase describer = this.getDescriber((TeamscaleIssue)item);
        for (TypedMultiMapRule<String, Pair<String, String>> parsedRule : this.parsedAvoidSymbolRules) {
            if (!parsedRule.matches(item)) continue;
            for (Map.Entry<String, Pair<String, String>> entry : parsedRule.map.entrySet()) {
                this.extractFieldRule(entry, describer, item);
            }
        }
    }

    private void extractFieldRule(Map.Entry<String, Pair<String, String>> ruleSet, WorkItemDescriberBase<SpecItem> describer, SpecItem item) {
        String exceptionPattern = (String)ruleSet.getValue().getSecond();
        Pattern prohibitedSymbolPattern = Pattern.compile("[" + Pattern.quote((String)ruleSet.getValue().getFirst()) + "]");
        if (ruleSet.getKey().contains("ALL")) {
            List fieldNames = describer.getNonTechnicalKeys((TeamscaleIssue)item);
            for (String fieldName : fieldNames) {
                this.checkViolation(item, fieldName, exceptionPattern, prohibitedSymbolPattern, (WorkItemDescriberBase.IValueDescriber<SpecItem>)describer.getValueDescriber(fieldName));
            }
            return;
        }
        this.checkViolation(item, ruleSet.getKey(), exceptionPattern, prohibitedSymbolPattern, (WorkItemDescriberBase.IValueDescriber<SpecItem>)describer.getValueDescriber(ruleSet.getKey()));
    }

    private void checkViolation(SpecItem item, String field, String exception, Pattern prohibitedSymbolPattern, WorkItemDescriberBase.IValueDescriber<SpecItem> valueDescriber) {
        String fieldValue = StringUtils.emptyIfNull((String)valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED)).toLowerCase();
        if (fieldValue.isEmpty()) {
            return;
        }
        if (!exception.isBlank()) {
            Pattern exceptionPattern = Pattern.compile(exception);
            fieldValue = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)exceptionPattern, (String)fieldValue.toLowerCase());
        }
        Matcher matcher = prohibitedSymbolPattern.matcher(fieldValue);
        while (matcher.find()) {
            this.buildFinding(AvoidSymbolCheck.buildFindingMessage(matcher.group()), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW))).addFindingProperties(AvoidSymbolCheck.buildProperties(item, field, matcher.group())).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, String symbolViolation) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Expression", (Object)symbolViolation);
        return properties;
    }

    static String buildFindingMessage(String prohibitedSymbol) {
        return "Avoid Symbol: '" + MarkupUtils.escapeMarkdownRelevantSymbols((String)prohibitedSymbol) + "'";
    }
}

