/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia.parsable.rule;

import com.teamscale.wia.SpecItem;
import eu.cqse.check.framework.core.CheckException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithException;
import org.jspecify.annotations.NonNull;

public abstract class ParsableRule {
    public static final Pattern ASSIGNMENT_PATTERN = Pattern.compile("^\\s*(?<type>.+?)\\s*->\\s*(?<assignment>.+?)\\s*$");
    public static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(?<key>[^:]+)\\s*:\\s*(?<value>.+)");
    private static final Pattern ITEM_SPLIT_PATTERN = Pattern.compile("|", 16);
    private static final Pattern LINKAGE_SPLIT_PATTERN = Pattern.compile("::", 16);
    private static final Pattern PLUS_LINKAGE_SPLIT_PATTERN = Pattern.compile("+", 16);
    private static final String ANY_QUANTIFIER = "ANY";
    public static final String ALL_QUANTIFIER = "ALL";
    private final Set<String> itemTypes;

    public ParsableRule(Set<String> itemTypes) {
        this.itemTypes = itemTypes;
    }

    public Set<String> getItemTypes() {
        return this.itemTypes;
    }

    public boolean matches(@NonNull SpecItem item) {
        String typeHuman = item.getHumanReadableType();
        String typeAbbreviation = item.getTypeInfo() != null ? item.getTypeInfo().getTypeAbbreviation() : null;
        return this.itemTypes.stream().anyMatch(str -> str.equalsIgnoreCase(typeHuman) || str.equalsIgnoreCase(typeAbbreviation) || str.equalsIgnoreCase(ANY_QUANTIFIER));
    }

    public static abstract class RuleParser {
        public static final FunctionWithException<String, String, CheckException> TO_STRING = String::toString;
        public static final FunctionWithException<String, Integer, CheckException> TO_INTEGER = str -> {
            int valueInteger;
            try {
                valueInteger = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new CheckException("Unable to parse value %s (Integer)".formatted(str));
            }
            return valueInteger;
        };
        public static final FunctionWithException<String, Integer, CheckException> TO_POSITIVE = str -> {
            int valueInteger = (Integer)TO_INTEGER.apply(str);
            if (valueInteger <= 0) {
                throw new CheckException("Invalid value %s (must be greater than 0)".formatted(str));
            }
            return valueInteger;
        };

        public static @NonNull Pair<String, String> parseAssignment(@NonNull String rawRule) throws CheckException {
            Matcher ruleMatcher = ASSIGNMENT_PATTERN.matcher(rawRule.strip());
            if (!ruleMatcher.find()) {
                throw new CheckException("Unable to parse rule definition \"%s\", must match the following pattern: %s".formatted(rawRule, ASSIGNMENT_PATTERN.pattern()));
            }
            return Pair.createPair((Object)ruleMatcher.group("type").strip(), (Object)ruleMatcher.group("assignment").strip());
        }

        public static Set<String> parseSet(@NonNull String rawRule) {
            return Arrays.stream(ITEM_SPLIT_PATTERN.split(rawRule.strip())).map(String::strip).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet());
        }

        public static @NonNull Pair<String, String> parseKeyValue(@NonNull String rawRule) throws CheckException {
            Matcher fieldMatcher = KEY_VALUE_PATTERN.matcher(rawRule.strip());
            if (!fieldMatcher.find()) {
                throw new CheckException("Unable to parse entry \"%s\", must match the following pattern: %s".formatted(rawRule.strip(), KEY_VALUE_PATTERN.pattern()));
            }
            return Pair.createPair((Object)fieldMatcher.group("key").strip(), (Object)fieldMatcher.group("value").strip());
        }

        public static List<String> parseLinkedList(@NonNull String rawRule) {
            return Arrays.stream(LINKAGE_SPLIT_PATTERN.split(rawRule.strip())).map(String::strip).filter(Predicate.not(String::isBlank)).collect(Collectors.toCollection(LinkedList::new));
        }

        public static List<String> parseLinkedListPlus(@NonNull String rawRule) {
            return Arrays.stream(PLUS_LINKAGE_SPLIT_PATTERN.split(rawRule.strip())).map(String::strip).filter(Predicate.not(String::isBlank)).collect(Collectors.toCollection(LinkedList::new));
        }

        abstract ParsableRule parse(String var1) throws CheckException;
    }
}

