/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.policy.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.policy.webapi.PolicyConfiguration;
import com.microsoft.alm.teamfoundation.policy.webapi.PolicyEvaluationRecord;
import com.microsoft.alm.teamfoundation.policy.webapi.PolicyType;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class PolicyHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected PolicyHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public PolicyConfiguration createPolicyConfiguration(PolicyConfiguration configuration, String project, Integer configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, configuration, "application/json", "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public PolicyConfiguration createPolicyConfiguration(PolicyConfiguration configuration, UUID project, Integer configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, configuration, "application/json", "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public void deletePolicyConfiguration(String project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePolicyConfiguration(UUID project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public PolicyConfiguration getPolicyConfiguration(String project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public PolicyConfiguration getPolicyConfiguration(UUID project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public ArrayList<PolicyConfiguration> getPolicyConfigurations(String project) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyConfiguration>>(){});
    }

    public ArrayList<PolicyConfiguration> getPolicyConfigurations(UUID project) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyConfiguration>>(){});
    }

    public PolicyConfiguration updatePolicyConfiguration(PolicyConfiguration configuration, String project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, configuration, "application/json", "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public PolicyConfiguration updatePolicyConfiguration(PolicyConfiguration configuration, UUID project, int configurationId) {
        UUID locationId = UUID.fromString("dad91cbe-d183-45f8-9c6e-9c1164472121");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, configuration, "application/json", "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public PolicyEvaluationRecord getPolicyEvaluation(String project, UUID evaluationId) {
        UUID locationId = UUID.fromString("46aecb7a-5d2c-4647-897b-0209505a9fe4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("evaluationId", evaluationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyEvaluationRecord.class);
    }

    public PolicyEvaluationRecord getPolicyEvaluation(UUID project, UUID evaluationId) {
        UUID locationId = UUID.fromString("46aecb7a-5d2c-4647-897b-0209505a9fe4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("evaluationId", evaluationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyEvaluationRecord.class);
    }

    public PolicyEvaluationRecord requeuePolicyEvaluation(String project, UUID evaluationId) {
        UUID locationId = UUID.fromString("46aecb7a-5d2c-4647-897b-0209505a9fe4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("evaluationId", evaluationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyEvaluationRecord.class);
    }

    public PolicyEvaluationRecord requeuePolicyEvaluation(UUID project, UUID evaluationId) {
        UUID locationId = UUID.fromString("46aecb7a-5d2c-4647-897b-0209505a9fe4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("evaluationId", evaluationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyEvaluationRecord.class);
    }

    public ArrayList<PolicyEvaluationRecord> getPolicyEvaluations(String project, String artifactId, Boolean includeNotApplicable, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("c23ddff5-229c-4d04-a80b-0fdce9f360c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactId", artifactId);
        queryParameters.addIfNotNull("includeNotApplicable", includeNotApplicable);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyEvaluationRecord>>(){});
    }

    public ArrayList<PolicyEvaluationRecord> getPolicyEvaluations(UUID project, String artifactId, Boolean includeNotApplicable, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("c23ddff5-229c-4d04-a80b-0fdce9f360c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactId", artifactId);
        queryParameters.addIfNotNull("includeNotApplicable", includeNotApplicable);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyEvaluationRecord>>(){});
    }

    public PolicyConfiguration getPolicyConfigurationRevision(String project, int configurationId, int revisionId) {
        UUID locationId = UUID.fromString("fe1e68a2-60d3-43cb-855b-85e41ae97c95");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        routeValues.put("revisionId", revisionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public PolicyConfiguration getPolicyConfigurationRevision(UUID project, int configurationId, int revisionId) {
        UUID locationId = UUID.fromString("fe1e68a2-60d3-43cb-855b-85e41ae97c95");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        routeValues.put("revisionId", revisionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyConfiguration.class);
    }

    public ArrayList<PolicyConfiguration> getPolicyConfigurationRevisions(String project, int configurationId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("fe1e68a2-60d3-43cb-855b-85e41ae97c95");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyConfiguration>>(){});
    }

    public ArrayList<PolicyConfiguration> getPolicyConfigurationRevisions(UUID project, int configurationId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("fe1e68a2-60d3-43cb-855b-85e41ae97c95");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("configurationId", configurationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyConfiguration>>(){});
    }

    public PolicyType getPolicyType(String project, UUID typeId) {
        UUID locationId = UUID.fromString("44096322-2d3d-466a-bb30-d1b7de69f61f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("typeId", typeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyType.class);
    }

    public PolicyType getPolicyType(UUID project, UUID typeId) {
        UUID locationId = UUID.fromString("44096322-2d3d-466a-bb30-d1b7de69f61f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("typeId", typeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PolicyType.class);
    }

    public ArrayList<PolicyType> getPolicyTypes(String project) {
        UUID locationId = UUID.fromString("44096322-2d3d-466a-bb30-d1b7de69f61f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyType>>(){});
    }

    public ArrayList<PolicyType> getPolicyTypes(UUID project) {
        UUID locationId = UUID.fromString("44096322-2d3d-466a-bb30-d1b7de69f61f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PolicyType>>(){});
    }
}

