/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.sourcecontrol.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.AssociatedWorkItem;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.Comment;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitAsyncRefOperationParameters;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitBaseVersionDescriptor;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitBlobRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitBranchStats;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitCherryPick;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitCommit;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitCommitChanges;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitCommitDiffs;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitCommitRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitDeletedRepository;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitItem;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitItemRequestData;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequest;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestCommentThread;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestIteration;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestIterationChanges;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestQuery;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestSearchCriteria;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPullRequestStatus;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPush;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitPushSearchCriteria;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitQueryBranchStatsCriteria;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitQueryCommitsCriteria;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRefFavorite;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRefLockRequest;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRefUpdate;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRefUpdateResult;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRepository;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitRevert;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitStatus;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitSuggestion;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitTargetVersionDescriptor;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitTreeRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.GitVersionDescriptor;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.IdentityRefWithVote;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.VersionControlRecursionType;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.IdentityRef;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class GitHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected GitHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public GitBlobRef getBlob(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBlobRef.class);
    }

    public InputStream getBlobContent(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String project, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String project, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID project, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID project, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, "application/json", queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public GitBranchStats getBranch(String project, String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(String project, UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID project, String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID project, UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitBranchStats.class);
    }

    public ArrayList<GitBranchStats> getBranches(String project, String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranches(String project, UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranches(UUID project, String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranches(UUID project, UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranches(String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranches(UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, String repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, UUID repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, String project, String repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public ArrayList<GitBranchStats> getBranchStatsBatch(GitQueryBranchStatsCriteria searchCriteria, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitBranchStats>>(){});
    }

    public GitCommitChanges getChanges(String project, String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String project, String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(UUID project, String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(UUID project, String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitChanges.class);
    }

    public GitCherryPick createCherryPick(GitAsyncRefOperationParameters cherryPickToCreate, String project, String repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cherryPickToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick createCherryPick(GitAsyncRefOperationParameters cherryPickToCreate, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cherryPickToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick createCherryPick(GitAsyncRefOperationParameters cherryPickToCreate, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cherryPickToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick createCherryPick(GitAsyncRefOperationParameters cherryPickToCreate, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cherryPickToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPick(String project, int cherryPickId, String repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cherryPickId", cherryPickId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPick(String project, int cherryPickId, UUID repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cherryPickId", cherryPickId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPick(UUID project, int cherryPickId, String repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cherryPickId", cherryPickId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPick(UUID project, int cherryPickId, UUID repositoryId) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cherryPickId", cherryPickId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPickForRefName(String project, String repositoryId, String refName) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPickForRefName(String project, UUID repositoryId, String refName) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPickForRefName(UUID project, String repositoryId, String refName) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCherryPick getCherryPickForRefName(UUID project, UUID repositoryId, String refName) {
        UUID locationId = UUID.fromString("033bad68-9a14-43d1-90e0-59cb8856fef6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCherryPick.class);
    }

    public GitCommitDiffs getCommitDiffs(String project, String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(String project, UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID project, String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID project, UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", diffCommonCommit);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommitDiffs.class);
    }

    public GitCommit getCommit(String project, String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String project, String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(UUID project, String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(UUID project, String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", changeCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitCommit.class);
    }

    public ArrayList<GitCommitRef> getCommits(String project, String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommits(String project, UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommits(UUID project, String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommits(UUID project, UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommits(String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommits(UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(String project, String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(String project, UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(UUID project, String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(UUID project, UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPushCommits(UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("pushId", String.valueOf(pushId));
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String project, String repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String project, UUID repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID project, String repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID project, UUID repositoryId, Integer skip, Integer top, Boolean includeStatuses) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeStatuses", includeStatuses);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, searchCriteria, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitDeletedRepository> getDeletedRepositories(String project) {
        UUID locationId = UUID.fromString("2b6869c4-cb25-42b5-b7a3-0d3e6be0a11a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitDeletedRepository>>(){});
    }

    public ArrayList<GitDeletedRepository> getDeletedRepositories(UUID project) {
        UUID locationId = UUID.fromString("2b6869c4-cb25-42b5-b7a3-0d3e6be0a11a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitDeletedRepository>>(){});
    }

    public GitItem getItem(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public GitItem getItem(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public GitItem getItem(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitItem.class);
    }

    public InputStream getItemContent(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<GitItem> getItems(String project, String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public ArrayList<GitItem> getItems(String project, UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public ArrayList<GitItem> getItems(UUID project, String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public ArrayList<GitItem> getItems(UUID project, UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public ArrayList<GitItem> getItems(String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public ArrayList<GitItem> getItems(UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitItem>>(){});
    }

    public InputStream getItemText(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", latestProcessedChange);
        queryParameters.addIfNotNull("download", download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, String project, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<ArrayList<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<GitItem>>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(String project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(String project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(UUID project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestIterationCommits(UUID project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("e7ea0883-095f-4926-b5fb-f24691c26fb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public ArrayList<GitCommitRef> getPullRequestCommits(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitCommitRef>>(){});
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(String project, String repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(String project, UUID repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(UUID project, String repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(UUID project, UUID repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(String repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIterationChanges getPullRequestIterationChanges(UUID repositoryId, int pullRequestId, int iterationId, Integer top, Integer skip, Integer compareTo) {
        UUID locationId = UUID.fromString("4216bdcf-b6b1-4d59-8b82-c34cc183fc8b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$compareTo", compareTo);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIterationChanges.class);
    }

    public GitPullRequestIteration getPullRequestIteration(String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public GitPullRequestIteration getPullRequestIteration(UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public GitPullRequestIteration getPullRequestIteration(String project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public GitPullRequestIteration getPullRequestIteration(String project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public GitPullRequestIteration getPullRequestIteration(UUID project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public GitPullRequestIteration getPullRequestIteration(UUID project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestIteration.class);
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(String project, String repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(String project, UUID repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(UUID project, String repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(UUID project, UUID repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(String repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public ArrayList<GitPullRequestIteration> getPullRequestIterations(UUID repositoryId, int pullRequestId, Boolean includeCommits) {
        UUID locationId = UUID.fromString("d43911ee-6958-46b0-a42b-8445b8a0d004");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestIteration>>(){});
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, String repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, UUID repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, String project, String repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public GitPullRequestQuery getPullRequestQuery(GitPullRequestQuery queries, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("b3a6eebe-9cf0-49ea-b6cb-1a4c5f5007b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queries, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestQuery.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, reviewer, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, reviewers, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public void deletePullRequestReviewer(String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePullRequestReviewer(UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePullRequestReviewer(String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePullRequestReviewer(String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePullRequestReviewer(UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePullRequestReviewer(UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public IdentityRefWithVote getPullRequestReviewer(String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote getPullRequestReviewer(String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote getPullRequestReviewer(String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityRefWithVote.class);
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public ArrayList<IdentityRefWithVote> getPullRequestReviewers(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRefWithVote>>(){});
    }

    public GitPullRequest getPullRequestById(int pullRequestId) {
        UUID locationId = UUID.fromString("01a46dea-7d46-4d40-bc84-319e7c260d99");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public ArrayList<GitPullRequest> getPullRequestsByProject(String project, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("a5d28130-9cd2-40fa-9f08-902e7daa9efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequestsByProject(UUID project, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("a5d28130-9cd2-40fa-9f08-902e7daa9efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String project, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitPullRequestToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String project, String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String project, UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID project, String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID project, UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits, Boolean includeWorkItemRefs) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeWorkItemRefs", includeWorkItemRefs);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public ArrayList<GitPullRequest> getPullRequests(String project, String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequests(String project, UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequests(UUID project, String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequests(UUID project, UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequests(String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public ArrayList<GitPullRequest> getPullRequests(UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequest>>(){});
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, gitPullRequestToUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequest.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, String project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, String project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, UUID project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestIterationStatus(GitPullRequestStatus status, UUID project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(String repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(UUID repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(String project, String repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(String project, UUID repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(UUID project, String repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestIterationStatus(UUID project, UUID repositoryId, int pullRequestId, int iterationId, int statusId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(String project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(String project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(UUID project, String repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestIterationStatuses(UUID project, UUID repositoryId, int pullRequestId, int iterationId) {
        UUID locationId = UUID.fromString("75cf11c5-979f-4038-a76e-058a06adf2bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus createPullRequestStatus(GitPullRequestStatus status, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, status, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(String repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(UUID repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(String project, String repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(String project, UUID repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(UUID project, String repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public GitPullRequestStatus getPullRequestStatus(UUID project, UUID repositoryId, int pullRequestId, int statusId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("statusId", statusId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestStatus.class);
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public ArrayList<GitPullRequestStatus> getPullRequestStatuses(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("b5f6bb4f-8d1e-4d79-8d11-4c9172c99c35");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestStatus>>(){});
    }

    public Comment createComment(Comment comment, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment createComment(Comment comment, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment createComment(Comment comment, String project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment createComment(Comment comment, String project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment createComment(Comment comment, UUID project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment createComment(Comment comment, UUID project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public void deleteComment(String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteComment(UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteComment(String project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteComment(String project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteComment(UUID project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteComment(UUID project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public Comment getComment(String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment getComment(UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment getComment(String project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment getComment(String project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment getComment(UUID project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment getComment(UUID project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public ArrayList<Comment> getComments(String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public ArrayList<Comment> getComments(UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public ArrayList<Comment> getComments(String project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public ArrayList<Comment> getComments(String project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public ArrayList<Comment> getComments(UUID project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public ArrayList<Comment> getComments(UUID project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Comment>>(){});
    }

    public Comment updateComment(Comment comment, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment updateComment(Comment comment, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment updateComment(Comment comment, String project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment updateComment(Comment comment, String project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment updateComment(Comment comment, UUID project, String repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public Comment updateComment(Comment comment, UUID project, UUID repositoryId, int pullRequestId, int threadId, int commentId) {
        UUID locationId = UUID.fromString("965a3ec7-5ed8-455a-bdcb-835a5ea7fe7b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        routeValues.put("commentId", commentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, comment, "application/json", "application/json");
        return super.sendRequest(httpRequest, Comment.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread createThread(GitPullRequestCommentThread commentThread, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(String project, String repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(String project, UUID repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(UUID project, String repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(UUID project, UUID repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(String repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread getPullRequestThread(UUID repositoryId, int pullRequestId, int threadId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(String project, String repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(String project, UUID repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(UUID project, String repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(UUID project, UUID repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(String repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public ArrayList<GitPullRequestCommentThread> getThreads(UUID repositoryId, int pullRequestId, Integer iteration, Integer baseIteration) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$iteration", iteration);
        queryParameters.addIfNotNull("$baseIteration", baseIteration);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPullRequestCommentThread>>(){});
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, String project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, String project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, UUID project, String repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public GitPullRequestCommentThread updateThread(GitPullRequestCommentThread commentThread, UUID project, UUID repositoryId, int pullRequestId, int threadId) {
        UUID locationId = UUID.fromString("ab6e2e5d-a0b7-4153-b64a-a4efe0d49449");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("threadId", threadId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, commentThread, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPullRequestCommentThread.class);
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<AssociatedWorkItem> getPullRequestWorkItems(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public GitPush createPush(GitPush push, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, String project, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, push, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(String project, String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(String project, UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID project, String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID project, UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", includeRefUpdates);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitPush.class);
    }

    public ArrayList<GitPush> getPushes(String project, String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public ArrayList<GitPush> getPushes(String project, UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public ArrayList<GitPush> getPushes(UUID project, String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public ArrayList<GitPush> getPushes(UUID project, UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public ArrayList<GitPush> getPushes(String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public ArrayList<GitPush> getPushes(UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitPush>>(){});
    }

    public void createRefLockRequest(GitRefLockRequest refLockRequest, String project, String repositoryId) {
        UUID locationId = UUID.fromString("32863ac0-6a8a-4d9f-8afe-ba293b93ec3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refLockRequest, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void createRefLockRequest(GitRefLockRequest refLockRequest, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("32863ac0-6a8a-4d9f-8afe-ba293b93ec3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refLockRequest, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void createRefLockRequest(GitRefLockRequest refLockRequest, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("32863ac0-6a8a-4d9f-8afe-ba293b93ec3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refLockRequest, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void createRefLockRequest(GitRefLockRequest refLockRequest, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("32863ac0-6a8a-4d9f-8afe-ba293b93ec3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refLockRequest, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<GitRef> getRefs(String project, String repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRef> getRefs(String project, UUID repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRef> getRefs(UUID project, String repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRef> getRefs(UUID project, UUID repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRef> getRefs(String repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRef> getRefs(UUID repositoryId, String filter, Boolean includeLinks, Boolean latestStatusesOnly) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        queryParameters.addIfNotNull("latestStatusesOnly", latestStatusesOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRef>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String project, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String project, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID project, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public ArrayList<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID project, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefUpdateResult>>(){});
    }

    public GitRefFavorite createFavorite(GitRefFavorite favorite, String project) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, favorite, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRefFavorite.class);
    }

    public GitRefFavorite createFavorite(GitRefFavorite favorite, UUID project) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, favorite, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRefFavorite.class);
    }

    public void deleteRefFavorite(String project, int favoriteId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("favoriteId", favoriteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteRefFavorite(UUID project, int favoriteId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("favoriteId", favoriteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public GitRefFavorite getRefFavorite(String project, int favoriteId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("favoriteId", favoriteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRefFavorite.class);
    }

    public GitRefFavorite getRefFavorite(UUID project, int favoriteId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("favoriteId", favoriteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRefFavorite.class);
    }

    public ArrayList<GitRefFavorite> getRefFavorites(String project, String repositoryId, String identityId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("identityId", identityId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefFavorite>>(){});
    }

    public ArrayList<GitRefFavorite> getRefFavorites(UUID project, String repositoryId, String identityId) {
        UUID locationId = UUID.fromString("876f70af-5792-485a-a1c7-d0a7b2f42bbb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("identityId", identityId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRefFavorite>>(){});
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, gitRepositoryToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate, String project) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitRepositoryToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate, UUID project) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitRepositoryToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public void deleteRepository(UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteRepository(String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteRepository(UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<GitRepository> getRepositories(String project, Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRepository>>(){});
    }

    public ArrayList<GitRepository> getRepositories(UUID project, Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRepository>>(){});
    }

    public ArrayList<GitRepository> getRepositories(Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitRepository>>(){});
    }

    public GitRepository getRepository(String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(String project, String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, newRepositoryInfo, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, newRepositoryInfo, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, newRepositoryInfo, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRepository.class);
    }

    public GitRevert createRevert(GitAsyncRefOperationParameters revertToCreate, String project, String repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, revertToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert createRevert(GitAsyncRefOperationParameters revertToCreate, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, revertToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert createRevert(GitAsyncRefOperationParameters revertToCreate, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, revertToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert createRevert(GitAsyncRefOperationParameters revertToCreate, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, revertToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevert(String project, int revertId, String repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("revertId", revertId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevert(String project, int revertId, UUID repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("revertId", revertId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevert(UUID project, int revertId, String repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("revertId", revertId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevert(UUID project, int revertId, UUID repositoryId) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("revertId", revertId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevertForRefName(String project, String repositoryId, String refName) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevertForRefName(String project, UUID repositoryId, String refName) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevertForRefName(UUID project, String repositoryId, String refName) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitRevert getRevertForRefName(UUID project, UUID repositoryId, String refName) {
        UUID locationId = UUID.fromString("bc866058-5449-4715-9cf1-a510b6ff193c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("refName", refName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitRevert.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, String commitId, String repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, String commitId, UUID repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, String project, String commitId, String repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, String project, String commitId, UUID repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, UUID project, String commitId, String repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public GitStatus createCommitStatus(GitStatus gitCommitStatusToCreate, UUID project, String commitId, UUID repositoryId) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, gitCommitStatusToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, GitStatus.class);
    }

    public ArrayList<GitStatus> getStatuses(String project, String commitId, String repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitStatus> getStatuses(String project, String commitId, UUID repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitStatus> getStatuses(UUID project, String commitId, String repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitStatus> getStatuses(UUID project, String commitId, UUID repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitStatus> getStatuses(String commitId, String repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitStatus> getStatuses(String commitId, UUID repositoryId, Integer top, Integer skip, Boolean latestOnly) {
        UUID locationId = UUID.fromString("428dd4fb-fda5-4722-af02-9313b80305da");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("skip", skip);
        queryParameters.addIfNotNull("latestOnly", latestOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitStatus>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(String repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(UUID repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(String project, String repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public ArrayList<GitSuggestion> getSuggestions(UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9393b4fb-4445-4919-972b-9ad16f442d83");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<GitSuggestion>>(){});
    }

    public GitTreeRef getTree(String project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(String project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GitTreeRef.class);
    }

    public InputStream getTreeZip(String project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(String project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }
}

