/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.DeployPhaseTypes;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.AgentBasedDeployPhase;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DeployPhase;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.MachineGroupBasedDeployPhase;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.RunOnServerDeployPhase;
import java.io.IOException;

public class DeployPhaseDeserializer
extends JsonDeserializer<DeployPhase> {
    public DeployPhase deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode typeNode = rootNode.findValue("PhaseType");
        if (typeNode != null) {
            DeployPhaseTypes triggerType = null;
            if (typeNode.isInt() && typeNode.asInt() == DeployPhaseTypes.AGENT_BASED_DEPLOYMENT.getValue()) {
                triggerType = DeployPhaseTypes.AGENT_BASED_DEPLOYMENT;
            } else if (typeNode.isInt() && typeNode.asInt() == DeployPhaseTypes.RUN_ON_SERVER.getValue()) {
                triggerType = DeployPhaseTypes.RUN_ON_SERVER;
            } else if (typeNode.isInt() && typeNode.asInt() == DeployPhaseTypes.MACHINE_GROUP_BASED_DEPLOYMENT.getValue()) {
                triggerType = DeployPhaseTypes.MACHINE_GROUP_BASED_DEPLOYMENT;
            } else if (typeNode.isTextual() && DeployPhaseTypes.AGENT_BASED_DEPLOYMENT.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = DeployPhaseTypes.AGENT_BASED_DEPLOYMENT;
            } else if (typeNode.isTextual() && DeployPhaseTypes.RUN_ON_SERVER.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = DeployPhaseTypes.RUN_ON_SERVER;
            } else if (typeNode.isTextual() && DeployPhaseTypes.MACHINE_GROUP_BASED_DEPLOYMENT.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = DeployPhaseTypes.MACHINE_GROUP_BASED_DEPLOYMENT;
            }
            if (DeployPhaseTypes.AGENT_BASED_DEPLOYMENT == triggerType) {
                return (DeployPhase)rootNode.traverse((ObjectCodec)mapper).readValueAs(AgentBasedDeployPhase.class);
            }
            if (DeployPhaseTypes.RUN_ON_SERVER == triggerType) {
                return (DeployPhase)rootNode.traverse((ObjectCodec)mapper).readValueAs(RunOnServerDeployPhase.class);
            }
            if (DeployPhaseTypes.MACHINE_GROUP_BASED_DEPLOYMENT == triggerType) {
                return (DeployPhase)rootNode.traverse((ObjectCodec)mapper).readValueAs(MachineGroupBasedDeployPhase.class);
            }
        }
        return null;
    }
}

