/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.PolicyContext;
import com.microsoft.tfs.core.checkinpolicies.PolicyEditArgs;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationCancelledException;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.checkinpolicies.PolicyInstance;
import com.microsoft.tfs.core.checkinpolicies.PolicyType;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedEvent;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.StandardListenerList;

public abstract class PolicyBase
implements PolicyInstance {
    private volatile PendingCheckin pendingCheckin;
    private final ListenerList stateChangedEventListeners = new StandardListenerList();

    @Override
    public void addPolicyStateChangedListener(PolicyStateChangedListener listener) {
        Check.notNull(listener, "listener");
        this.stateChangedEventListeners.addListener(listener);
    }

    @Override
    public void removePolicyStateChangedListener(PolicyStateChangedListener listener) {
        Check.notNull(listener, "listener");
        this.stateChangedEventListeners.removeListener(listener);
    }

    protected void firePolicyStateChangedEvent(PolicyFailure[] failures) {
        PolicyFailure[] newFailures = failures == null ? new PolicyFailure[]{} : failures;
        this.firePolicyStateChangedEvent(new PolicyStateChangedEvent(EventSource.newFromHere(), newFailures, this));
    }

    protected void firePolicyStateChangedEvent(final PolicyStateChangedEvent event) {
        Check.notNull(event, "event");
        this.stateChangedEventListeners.foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PolicyStateChangedListener)listener).onPolicyStateChanged(event);
                return true;
            }
        });
    }

    protected PendingCheckin getPendingCheckin() {
        if (this.pendingCheckin == null) {
            throw new IllegalStateException(Messages.getString("PolicyBase.PolicyInstanceHasNotBeenInitialized"));
        }
        return this.pendingCheckin;
    }

    @Override
    public boolean canEdit() {
        return true;
    }

    @Override
    public void activate(PolicyFailure failure, PolicyContext context) {
    }

    @Override
    public void displayHelp(PolicyFailure failure, PolicyContext context) {
    }

    @Override
    public void initialize(PendingCheckin pendingCheckin, PolicyContext context) {
        Check.notNull(pendingCheckin, "pendingCheckin");
        this.pendingCheckin = pendingCheckin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ListenerList listenerList = this.stateChangedEventListeners;
        synchronized (listenerList) {
            this.stateChangedEventListeners.clear();
        }
    }

    @Override
    public abstract void loadConfiguration(Memento var1);

    @Override
    public abstract void saveConfiguration(Memento var1);

    @Override
    public abstract boolean edit(PolicyEditArgs var1);

    @Override
    public abstract PolicyType getPolicyType();

    @Override
    public abstract PolicyFailure[] evaluate(PolicyContext var1) throws PolicyEvaluationCancelledException;
}

