/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies.loaders;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.PolicyInstance;
import com.microsoft.tfs.core.checkinpolicies.PolicyLoader;
import com.microsoft.tfs.core.checkinpolicies.PolicyLoaderException;
import com.microsoft.tfs.core.checkinpolicies.loaders.internal.PolicyInstanceProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClasspathPolicyLoader
implements PolicyLoader {
    public static final String POLICY_INSTANCE_PROPERTIES_FILENAME = "checkin-policy-instance.properties";
    private static final Log log = LogFactory.getLog(ClasspathPolicyLoader.class);

    @Override
    public PolicyInstance load(String policyTypeID) throws PolicyLoaderException {
        log.debug((Object)MessageFormat.format("Trying to load policy instance for policy type ID '{0}'", policyTypeID));
        PolicyInstanceProperties[] propertiesFiles = this.getAllPolicyInstanceProperties();
        for (int i = 0; i < propertiesFiles.length; ++i) {
            if (!propertiesFiles[i].getID().equals(policyTypeID)) continue;
            PolicyInstance ret = null;
            try {
                ret = this.loadPolicyInstanceClass(propertiesFiles[i].getClassName());
            }
            catch (PolicyLoaderException e) {
                log.error((Object)MessageFormat.format("Could not instantiate class {0} for policy type ID '{1}'.  Other classes that support this ID may still be loaded.", propertiesFiles[i].getClassName(), propertiesFiles[i].getID()), (Throwable)e);
            }
            if (ret != null && !ret.getPolicyType().getID().equals(policyTypeID)) {
                String messageFormat = "Class {0} was named in a properties file, but this class supports a different type ID '{1}' than requested ID '{2}'";
                String message = MessageFormat.format("Class {0} was named in a properties file, but this class supports a different type ID '{1}' than requested ID '{2}'", propertiesFiles[i].getClassName(), ret.getPolicyType().getID(), policyTypeID);
                log.error((Object)message);
                throw new PolicyLoaderException(message, null);
            }
            if (ret == null) continue;
            return ret;
        }
        log.warn((Object)MessageFormat.format("Could not load any policies that support policy type ID '{0}'", policyTypeID));
        return null;
    }

    @Override
    public String[] getAvailablePolicyTypeIDs() throws PolicyLoaderException {
        log.debug((Object)"Searching for available policy type IDs");
        PolicyInstanceProperties[] propertiesFiles = this.getAllPolicyInstanceProperties();
        String[] ids = new String[propertiesFiles.length];
        for (int i = 0; i < propertiesFiles.length; ++i) {
            ids[i] = propertiesFiles[i].getID();
        }
        log.debug((Object)MessageFormat.format("Found {0} IDs", Integer.toString(ids.length)));
        return ids;
    }

    private PolicyInstance loadPolicyInstanceClass(String className) throws PolicyLoaderException {
        try {
            Class<?> instanceClass = ClasspathPolicyLoader.class.getClassLoader().loadClass(className);
            Object newInstance = instanceClass.newInstance();
            if (!(newInstance instanceof PolicyInstance)) {
                String messageFormat = "Class name {0} loaded successfully, but it does not implement the {1} interface so it cannot be used";
                String message = MessageFormat.format("Class name {0} loaded successfully, but it does not implement the {1} interface so it cannot be used", className, PolicyInstance.class.getName());
                log.error((Object)message);
                throw new PolicyLoaderException(message, null);
            }
            return (PolicyInstance)newInstance;
        }
        catch (ClassNotFoundException e) {
            String message = Messages.getString("ClasspathPolicyLoader.ErrorLoadingPolicyInstanceClass");
            log.warn((Object)message, (Throwable)e);
            throw new PolicyLoaderException(message, e, null);
        }
        catch (InstantiationException e) {
            String message = Messages.getString("ClasspathPolicyLoader.ErrorInstantiatingPolicyInstanceClass");
            log.error((Object)message, (Throwable)e);
            throw new PolicyLoaderException(message, e, null);
        }
        catch (IllegalAccessException e) {
            String message = Messages.getString("ClasspathPolicyLoader.AccessErrorInstantiatingPolicyInstanceClass");
            log.error((Object)message, (Throwable)e);
            throw new PolicyLoaderException(message, e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyInstanceProperties[] getAllPolicyInstanceProperties() throws PolicyLoaderException {
        Enumeration<URL> propertiesFileResources;
        ArrayList<PolicyInstanceProperties> propertiesList = new ArrayList<PolicyInstanceProperties>();
        try {
            propertiesFileResources = ClasspathPolicyLoader.class.getClassLoader().getResources(POLICY_INSTANCE_PROPERTIES_FILENAME);
        }
        catch (IOException e) {
            String messageFormat = "Error getting properties resources ('{0}') from classloader";
            String message = MessageFormat.format("Error getting properties resources ('{0}') from classloader", POLICY_INSTANCE_PROPERTIES_FILENAME);
            log.warn((Object)message, (Throwable)e);
            throw new PolicyLoaderException(e, null);
        }
        while (propertiesFileResources.hasMoreElements()) {
            URL propertiesResourceURL = propertiesFileResources.nextElement();
            InputStream propertiesResourceInputStream = null;
            try {
                propertiesResourceInputStream = propertiesResourceURL.openStream();
                PolicyInstanceProperties props = PolicyInstanceProperties.load(propertiesResourceInputStream);
                String messageFormat = "Check-in policy properties file {0} declares policy type ID '{1}' is implemented by class {2}";
                String message = MessageFormat.format("Check-in policy properties file {0} declares policy type ID '{1}' is implemented by class {2}", propertiesResourceURL.toString(), props.getID(), props.getClassName());
                log.info((Object)message);
                propertiesList.add(props);
            }
            catch (IOException e) {
                log.error((Object)"Error reading properties input stream, continuing", (Throwable)e);
            }
            finally {
                try {
                    if (propertiesResourceInputStream == null) continue;
                    propertiesResourceInputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing properties input stream, continuing", (Throwable)e);
                }
            }
        }
        return propertiesList.toArray(new PolicyInstanceProperties[propertiesList.size()]);
    }
}

