/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.BuildConstants;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.flags.BuildQueryOrder;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.Calendar;
import ms.tfs.build.buildservice._04._BuildDetailSpec;

public class BuildDetailSpec
extends WebServiceObjectWrapper
implements IBuildDetailSpec {
    private BuildDetailSpec() {
        super(new _BuildDetailSpec());
    }

    public BuildDetailSpec(String teamProject) {
        this(new BuildDefinitionSpec(teamProject));
    }

    public BuildDetailSpec(String teamProject, String definitionName) {
        this(new BuildDefinitionSpec(teamProject, definitionName));
    }

    public BuildDetailSpec(IBuildDefinition definition) {
        this(new BuildDefinitionSpec(definition));
    }

    public BuildDetailSpec(IBuildDefinitionSpec definitionSpec) {
        this();
        this.setDefaults();
        this.getWebServiceObject().setDefinitionSpec(((BuildDefinitionSpec)definitionSpec).getWebServiceObject());
    }

    public _BuildDetailSpec getWebServiceObject() {
        return (_BuildDetailSpec)this.webServiceObject;
    }

    @Override
    public String getBuildNumber() {
        return this.getWebServiceObject().getBuildNumber();
    }

    @Override
    public void setBuildNumber(String value) {
        this.getWebServiceObject().setBuildNumber(value);
    }

    @Override
    public String[] getInformationTypes() {
        return (String[])this.getWebServiceObject().getInformationTypes().clone();
    }

    @Override
    public void setInformationTypes(String[] value) {
        this.getWebServiceObject().setInformationTypes(value);
    }

    @Override
    public int getMaxBuildsPerDefinition() {
        return this.getWebServiceObject().getMaxBuildsPerDefinition();
    }

    @Override
    public void setMaxBuildsPerDefinition(int value) {
        this.getWebServiceObject().setMaxBuildsPerDefinition(value);
    }

    @Override
    public Calendar getMaxFinishTime() {
        return this.getWebServiceObject().getMaxFinishTime();
    }

    @Override
    public void setMaxFinishTime(Calendar value) {
        this.getWebServiceObject().setMaxFinishTime(value);
    }

    @Override
    public Calendar getMinChangedTime() {
        return this.getWebServiceObject().getMinChangedTime();
    }

    @Override
    public void setMinChangedTime(Calendar value) {
        this.getWebServiceObject().setMinChangedTime(value);
    }

    @Override
    public Calendar getMinFinishTime() {
        return this.getWebServiceObject().getMinFinishTime();
    }

    @Override
    public void setMinFinishTime(Calendar value) {
        this.getWebServiceObject().setMinFinishTime(value);
    }

    @Override
    public String getQuality() {
        return this.getWebServiceObject().getQuality();
    }

    @Override
    public void setQuality(String value) {
        this.getWebServiceObject().setQuality(value);
    }

    @Override
    public QueryDeletedOption getQueryDeletedOption() {
        return QueryDeletedOption.fromWebServiceObject(this.getWebServiceObject().getQueryDeletedOption());
    }

    @Override
    public void setQueryDeletedOption(QueryDeletedOption value) {
        this.getWebServiceObject().setQueryDeletedOption(value.getWebServiceObject());
    }

    @Override
    public QueryOptions getQueryOptions() {
        return QueryOptions.fromWebServiceObject(this.getWebServiceObject().getQueryOptions());
    }

    @Override
    public void setQueryOptions(QueryOptions value) {
        this.getWebServiceObject().setQueryOptions(value.getWebServiceObject());
    }

    @Override
    public BuildQueryOrder getQueryOrder() {
        return BuildQueryOrder.fromWebServiceObject(this.getWebServiceObject().getQueryOrder());
    }

    @Override
    public void setQueryOrder(BuildQueryOrder value) {
        this.getWebServiceObject().setQueryOrder(value.getWebServiceObject());
    }

    @Override
    public BuildReason getReason() {
        return BuildReason.fromWebServiceObject(this.getWebServiceObject().getReason());
    }

    @Override
    public void setReason(BuildReason value) {
        this.getWebServiceObject().setReason(value.getWebServiceObject());
    }

    @Override
    public String getRequestedFor() {
        return this.getWebServiceObject().getRequestedFor();
    }

    @Override
    public void setRequestedFor(String value) {
        this.getWebServiceObject().setRequestedFor(value);
    }

    @Override
    public BuildStatus getStatus() {
        return BuildStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    @Override
    public void setStatus(BuildStatus value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }

    @Override
    public String[] getDefinitionURIs() {
        return this.getWebServiceObject().getDefinitionUris();
    }

    @Override
    public IBuildDefinitionSpec getDefinitionSpec() {
        return new BuildDefinitionSpec(this.getWebServiceObject().getDefinitionSpec());
    }

    private void setDefaults() {
        _BuildDetailSpec detail = this.getWebServiceObject();
        detail.setBuildNumber("*");
        detail.setMinFinishTime(DotNETDate.MIN_CALENDAR);
        detail.setMaxFinishTime(DotNETDate.MIN_CALENDAR);
        detail.setMinChangedTime(DotNETDate.MIN_CALENDAR);
        BuildStatus status = BuildStatus.SUCCEEDED;
        status = status.combine(BuildStatus.PARTIALLY_SUCCEEDED);
        status = status.combine(BuildStatus.STOPPED);
        status = status.combine(BuildStatus.FAILED);
        status = status.combine(BuildStatus.NOT_STARTED);
        status = status.combine(BuildStatus.IN_PROGRESS);
        detail.setStatus(status.getWebServiceObject());
        detail.setQueryOptions(QueryOptions.ALL.getWebServiceObject());
        detail.setInformationTypes(BuildConstants.ALL_INFORMATION_TYPES);
    }
}

