/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.utils;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.exceptions.BuildTypeFileParseException;
import com.microsoft.tfs.core.clients.build.internal.BuildTypeInfo;
import com.microsoft.tfs.core.clients.build.internal.utils.BasicBuildTypeParseHandler;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.temp.TempStorageService;
import com.microsoft.tfs.util.xml.SAXUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildTypeUtil {
    private static final Log log = LogFactory.getLog(BuildTypeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildTypeInfo parseBuildTypeFile(IBuildServer server, Item item) throws IOException {
        BuildTypeInfo info;
        Check.notNull(item, "item");
        String buildTypeName = ServerPath.getFileName(ServerPath.getParent(item.getServerItem()));
        String fileName = MessageFormat.format("{0}-{1}", buildTypeName, "TFSBuild.proj");
        File localBuildFile = item.downloadFileToTempLocation(server.getConnection().getVersionControlClient(), fileName);
        try {
            info = BuildTypeUtil.parseBuildTypeInfo(buildTypeName, localBuildFile, item.getEncoding());
        }
        finally {
            try {
                localBuildFile.delete();
            }
            catch (Exception e) {
                log.error((Object)Messages.getString("BuildTypeUtil.ErrorDeletingTemporaryBuildProjectFile"), (Throwable)e);
            }
            TempStorageService.getInstance().cleanUpItem(localBuildFile.getParentFile());
        }
        return info;
    }

    public static BuildTypeInfo parseBuildTypeInfo(String buildTypeName, File localBuildFile, FileEncoding encoding) throws IOException {
        BasicBuildTypeParseHandler handler = new BasicBuildTypeParseHandler(buildTypeName);
        try {
            SAXParser saxParser = SAXUtils.newSAXParser();
            saxParser.parse(localBuildFile, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            String message = MessageFormat.format(Messages.getString("BuildTypeUtil.SAXExceptionParsingFileFormat"), localBuildFile.getPath(), e.getLocalizedMessage());
            log.error((Object)message, (Throwable)e);
            throw new BuildTypeFileParseException(message, e);
        }
        catch (ParserConfigurationException e) {
            String message = MessageFormat.format(Messages.getString("BuildTypeUtil.ParserConfigurationExceptionParsingFileFormat"), localBuildFile.getPath(), e.getLocalizedMessage());
            log.error((Object)message, (Throwable)e);
            throw new BuildTypeFileParseException(message, e);
        }
        return handler.getBuildTypeInfo();
    }
}

