/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.commonstructure;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class CSSStructureType {
    public static final CSSStructureType PROJECT_MODEL_HIERARCHY = new CSSStructureType("ProjectModelHierarchy");
    public static final CSSStructureType PROJECT_LIFECYCLE = new CSSStructureType("ProjectLifecycle");
    private final String structureType;

    public static CSSStructureType fromString(String structureType) {
        Check.notNull(structureType, "structureType");
        if (PROJECT_MODEL_HIERARCHY.getStructureType().equals(structureType)) {
            return PROJECT_MODEL_HIERARCHY;
        }
        if (PROJECT_LIFECYCLE.getStructureType().equals(structureType)) {
            return PROJECT_LIFECYCLE;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unkown structure type \"{0}\"", structureType));
    }

    private CSSStructureType(String structureType) {
        this.structureType = structureType;
    }

    public String getStructureType() {
        return this.structureType;
    }

    public String toString() {
        return this.structureType;
    }

    public int hashCode() {
        return this.structureType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.structureType.equals(obj.toString());
    }
}

