/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.commonstructure;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.CSSNode;
import com.microsoft.tfs.core.clients.commonstructure.CSSStructureType;
import com.microsoft.tfs.core.clients.commonstructure.CommonStructureException;
import com.microsoft.tfs.core.clients.commonstructure.NodeInfo;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.commonstructure.ProjectProperty;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.exceptions.mappers.ClassificationExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import ms.tfs.services.classification._03._Classification4Soap;
import ms.tfs.services.classification._03._ClassificationSoap;
import ms.tfs.services.classification._03._NodeInfo;
import ms.tfs.services.classification._03._ProjectInfo;
import ms.tfs.services.classification._03._ProjectProperty;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonStructureClient {
    private final TFSTeamProjectCollection connection;
    private final _ClassificationSoap webService;
    private final _Classification4Soap webService4;
    private final Object cacheLock = new Object();
    private final HashMap<String, Object> projectInfoCacheByUri = new HashMap();
    private final HashMap<String, Object> projectInfoCacheByName = new HashMap();

    public CommonStructureClient(TFSTeamProjectCollection connection, _ClassificationSoap webService, _Classification4Soap webService4) {
        Check.notNull(connection, "connection");
        Check.notNull(webService, "webService");
        this.connection = connection;
        this.webService = webService;
        this.webService4 = webService4;
    }

    public TFSTeamProjectCollection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProjectInfoCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.projectInfoCacheByUri.clear();
            this.projectInfoCacheByName.clear();
        }
    }

    public String createNode(String nodeName, String parentNodeUri) {
        String nodeUri;
        try {
            nodeUri = this.webService.createNode(nodeName, parentNodeUri);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        return nodeUri;
    }

    public void deleteBranches(String[] nodeUris, String reclassifyUri) {
        try {
            this.webService.deleteBranches(nodeUris, reclassifyUri);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject(String projectUri) {
        try {
            Object object = this.cacheLock;
            synchronized (object) {
                ProjectInfo pi = (ProjectInfo)this.projectInfoCacheByUri.get(projectUri);
                this.projectInfoCacheByUri.remove(projectUri);
                this.projectInfoCacheByName.remove(pi.getName());
            }
            this.webService.deleteProject(projectUri);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public String getChangedNodes(int firstSequenceId) {
        String changedNodes;
        try {
            changedNodes = this.webService.getChangedNodes(firstSequenceId);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        return changedNodes;
    }

    public NodeInfo getNode(String nodeUri) {
        NodeInfo nodeInfo;
        try {
            _NodeInfo ni = this.webService.getNode(nodeUri);
            nodeInfo = new NodeInfo(ni);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        return nodeInfo;
    }

    public NodeInfo getNodeFrom(String nodePath) {
        NodeInfo nodeInfo;
        try {
            _NodeInfo ni = this.webService.getNodeFromPath(nodePath);
            nodeInfo = new NodeInfo(ni);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        return nodeInfo;
    }

    public CSSNode getCSSNodes(String rootNodeUri, boolean includeChildren) {
        CSSNode[] nodes = this.getCSSNodes(new String[]{rootNodeUri}, includeChildren);
        if (nodes.length == 0) {
            throw new TECoreException(MessageFormat.format("Unable to find nodes for \"{0}\"", rootNodeUri));
        }
        if (nodes.length > 1) {
            throw new TECoreException(MessageFormat.format("Too many nodes returned for \"{0}\".  Found {1}", rootNodeUri, nodes.length));
        }
        return nodes[0];
    }

    public CSSNode[] getCSSNodes(String[] rootNodeUris, boolean includeChildren) {
        CSSNode[] nodeArray;
        try {
            DOMAnyContentType result = (DOMAnyContentType)this.webService.getNodesXml(rootNodeUris, includeChildren, new DOMAnyContentType());
            NodeList nodes = result.getElements()[0].getChildNodes();
            nodeArray = new CSSNode[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                nodeArray[i] = this.getCSSNode(nodes.item(i));
            }
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        return nodeArray;
    }

    private CSSNode getCSSNode(Node node) {
        CSSNode cssNode = new CSSNode(CSSStructureType.fromString(this.getAttributeValue(node, "StructureType")), this.getAttributeValue(node, "NodeID"), this.getAttributeValue(node, "Name"), this.getAttributeValue(node, "ParentID"), this.getAttributeValue(node, "Path"), this.getAttributeValue(node, "ProjectID"));
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            if ("Children".equals(children.item(0).getNodeName())) {
                children = children.item(0).getChildNodes();
            }
            for (int i = 0; i < children.getLength(); ++i) {
                cssNode.addChild(this.getCSSNode(children.item(i)));
            }
        }
        return cssNode;
    }

    private String getAttributeValue(Node node, String attributeName) {
        if (node == null || node.getAttributes() == null || node.getAttributes().getNamedItem(attributeName) == null) {
            return null;
        }
        return node.getAttributes().getNamedItem(attributeName).getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo getProject(String projectUri) {
        ProjectInfo projectInfo = null;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.projectInfoCacheByUri.containsKey(projectUri)) {
                projectInfo = (ProjectInfo)this.projectInfoCacheByUri.get(projectUri);
            } else {
                try {
                    _ProjectInfo pi = this.webService.getProject(projectUri);
                    if (pi != null) {
                        projectInfo = new ProjectInfo(pi);
                        projectInfo.setSourceControlCapabilityFlags(this.connection.getSourceControlCapability(projectInfo));
                        this.projectInfoCacheByUri.put(projectUri, projectInfo);
                        this.projectInfoCacheByName.put(pi.getName(), projectInfo);
                    }
                }
                catch (ProxyException e) {
                    throw ClassificationExceptionMapper.map(e);
                }
            }
        }
        return projectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo getProjectFromName(String projectName) {
        ProjectInfo projectInfo = null;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.projectInfoCacheByName.containsKey(projectName)) {
                projectInfo = (ProjectInfo)this.projectInfoCacheByName.get(projectName);
            } else {
                try {
                    _ProjectInfo pi = this.webService.getProjectFromName(projectName);
                    if (pi != null) {
                        projectInfo = new ProjectInfo(pi);
                        projectInfo.setSourceControlCapabilityFlags(this.connection.getSourceControlCapability(projectInfo));
                        this.projectInfoCacheByName.put(pi.getName(), projectInfo);
                        this.projectInfoCacheByUri.put(pi.getUri(), projectInfo);
                    }
                }
                catch (ProxyException e) {
                    throw ClassificationExceptionMapper.map(e);
                }
            }
        }
        return projectInfo;
    }

    public ProjectInfo[] listAllProjects() {
        _ProjectInfo[] projectInfoArray;
        try {
            projectInfoArray = this.webService.listAllProjects();
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        ProjectInfo[] aProjectInfoArray = new ProjectInfo[projectInfoArray.length];
        for (int i = 0; i < projectInfoArray.length; ++i) {
            aProjectInfoArray[i] = new ProjectInfo(projectInfoArray[i]);
            aProjectInfoArray[i].setSourceControlCapabilityFlags(this.connection.getSourceControlCapability(aProjectInfoArray[i]));
        }
        return aProjectInfoArray;
    }

    public ProjectInfo[] listProjects() {
        _ProjectInfo[] projectInfoArray;
        try {
            projectInfoArray = this.webService.listProjects();
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        ProjectInfo[] aProjectInfoArray = new ProjectInfo[projectInfoArray.length];
        for (int i = 0; i < projectInfoArray.length; ++i) {
            aProjectInfoArray[i] = new ProjectInfo(projectInfoArray[i]);
            aProjectInfoArray[i].setSourceControlCapabilityFlags(this.connection.getSourceControlCapability(aProjectInfoArray[i]));
        }
        return aProjectInfoArray;
    }

    public NodeInfo[] listStructures(String projectUri) {
        _NodeInfo[] nodeInfoArray;
        try {
            nodeInfoArray = this.webService.listStructures(projectUri);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
        NodeInfo[] aNodeInfoArray = new NodeInfo[nodeInfoArray.length];
        for (int i = 0; i < nodeInfoArray.length; ++i) {
            aNodeInfoArray[i] = new NodeInfo(nodeInfoArray[i]);
        }
        return aNodeInfoArray;
    }

    public void moveBranch(String nodeUri, String newParentNodeUri) {
        try {
            this.webService.moveBranch(nodeUri, newParentNodeUri);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public void renameNode(String nodeUri, String newNodeName) {
        try {
            this.webService.renameNode(nodeUri, newNodeName);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public void reorderNode(String nodeUri, int moveBy) {
        try {
            this.webService.reorderNode(nodeUri, moveBy);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public void updateProjectProperties(String projectUri, String state, ProjectProperty[] properties) {
        _ProjectProperty[] pp = null;
        if (properties != null) {
            pp = new _ProjectProperty[properties.length];
            for (int i = 0; i < pp.length; ++i) {
                pp[i] = new _ProjectProperty(properties[i].getName(), properties[i].getValue());
            }
        }
        try {
            this.webService.updateProjectProperties(projectUri, state, pp);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public String createNode(String nodeName, String parentNodeUri, Calendar startDate, Calendar finishDate) {
        if (this.webService4 == null) {
            throw new CommonStructureException(Messages.getString("CommonStructureClient.ServerDoesNotSupportMethod"));
        }
        try {
            return this.webService4.createNodeWithDates(nodeName, parentNodeUri, startDate, finishDate);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public void setIterationDates(String nodeUri, Calendar startDate, Calendar finishDate) {
        if (this.webService4 == null) {
            throw new CommonStructureException(Messages.getString("CommonStructureClient.ServerDoesNotSupportMethod"));
        }
        try {
            this.webService4.setIterationDates(nodeUri, startDate, finishDate);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public ProjectProperty getProjectProperty(String projectUri, String name) {
        if (this.webService4 == null) {
            throw new CommonStructureException(Messages.getString("CommonStructureClient.ServerDoesNotSupportMethod"));
        }
        try {
            return new ProjectProperty(this.webService4.getProjectProperty(projectUri, name));
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }

    public void setProjectProperty(String projectUri, String name, String value) {
        if (this.webService4 == null) {
            throw new CommonStructureException(Messages.getString("CommonStructureClient.ServerDoesNotSupportMethod"));
        }
        try {
            this.webService4.setProjectProperty(projectUri, name, value);
        }
        catch (ProxyException e) {
            throw ClassificationExceptionMapper.map(e);
        }
    }
}

