/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.favorites;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.favorites.IFavoritesStore;
import com.microsoft.tfs.core.clients.favorites.IdentityFavoritesStore;
import com.microsoft.tfs.core.clients.teamsettings.TeamConfiguration;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public abstract class FavoritesStoreFactory {
    public static IFavoritesStore create(TFSTeamProjectCollection connection, ProjectInfo currentProject, TeamConfiguration currentTeam, String featureScope, boolean isPersonal) {
        Check.notNull(connection, "connection");
        Check.notNullOrEmpty(featureScope, "featureScope");
        if (currentProject == null) {
            return null;
        }
        GUID identity = FavoritesStoreFactory.getIdentity(connection, currentTeam, isPersonal);
        String filterNamespace = FavoritesStoreFactory.generateQueryNamespace(currentProject, currentTeam, featureScope, isPersonal);
        IdentityFavoritesStore store = new IdentityFavoritesStore();
        store.connect(connection, filterNamespace, identity);
        if (!store.isConnected()) {
            return null;
        }
        return store;
    }

    private static GUID getIdentity(TFSTeamProjectCollection connection, TeamConfiguration currentTeam, boolean isPersonal) {
        Check.notNull(connection, "connection");
        if (isPersonal) {
            return connection.getAuthorizedIdentity().getTeamFoundationID();
        }
        if (currentTeam != null) {
            return currentTeam.getTeamID();
        }
        return GUID.EMPTY;
    }

    private static String generateQueryNamespace(ProjectInfo project, TeamConfiguration team, String featureScope, boolean isPersonal) {
        Check.notNull(project, "project");
        StringBuilder scopeParts = new StringBuilder();
        scopeParts.append(FavoritesStoreFactory.getFavoritesTypeNamespace());
        scopeParts.append('.');
        scopeParts.append(project.getGUID());
        if (!isPersonal && team != null && !GUID.EMPTY.equals(team.getTeamID())) {
            scopeParts.append('.');
            scopeParts.append(team.getTeamID().getGUIDString());
        }
        if (featureScope != null && featureScope.trim().length() > 0) {
            scopeParts.append('.');
            scopeParts.append(featureScope);
        }
        return scopeParts.toString();
    }

    private static String getFavoritesTypeNamespace() {
        return "Microsoft.TeamFoundation.Framework.Server.IdentityFavorites.";
    }
}

