/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.AnalysisDatabaseEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingServerEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamFoundationServerEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.WarehouseDatabaseEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.ReportingFolderEntityUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportingFolderCompatibilityEntity
extends TFSCompatibilityEntity
implements ReportingFolderEntity {
    private static final Log log = LogFactory.getLog(ReportingFolderCompatibilityEntity.class);
    private final String itemPath;

    public ReportingFolderCompatibilityEntity(TFSCompatibilityEntity parent, String itemPath) {
        super(parent);
        Check.notNull(itemPath, "itemPath");
        this.itemPath = itemPath;
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.REPORTING_FOLDER;
    }

    @Override
    public String getDisplayName() {
        return "Reporting Folder";
    }

    @Override
    public String getItemPath() {
        return this.itemPath;
    }

    @Override
    public String getFullItemPath() {
        return ReportingFolderEntityUtils.getFullItemPath(this);
    }

    @Override
    public TFSEntity getReferencedResource() {
        return null;
    }

    @Override
    public WarehouseDatabaseEntity getWarehouseDatabase() {
        return null;
    }

    @Override
    public AnalysisDatabaseEntity getAnalysisDatabase() {
        return null;
    }

    @Override
    public ReportingServerEntity getReportingServer() {
        TFSEntity ancestor = this.getParent();
        if (ancestor instanceof TeamProjectEntity) {
            ancestor = ancestor.getParent();
        }
        if (ancestor instanceof ProjectCollectionEntity && (ancestor = ancestor.getParent()) instanceof TeamFoundationServerEntity && (ancestor = ancestor.getParent()) instanceof OrganizationalRootEntity) {
            return ((OrganizationalRootEntity)ancestor).getReportingServer();
        }
        log.warn((Object)"Inconsistent parentage in ReportingFolderCompatibilityEntity");
        return null;
    }
}

