/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.util.Check;

public abstract class TFSCompatibilityEntity
implements TFSEntity {
    private final TFSTeamProjectCollection connection;
    private final TFSCompatibilityEntity parent;

    protected TFSCompatibilityEntity(TFSTeamProjectCollection connection) {
        Check.notNull(connection, "connection");
        this.connection = connection;
        this.parent = null;
    }

    protected TFSCompatibilityEntity(TFSCompatibilityEntity parent) {
        Check.notNull(parent, "parent");
        Check.notNull(parent.connection, "connection");
        this.connection = parent.connection;
        this.parent = parent;
    }

    protected TFSTeamProjectCollection getConnection() {
        return this.connection;
    }

    @Override
    public final TFSEntity getParent() {
        return this.parent;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getDisplayPath() {
        StringBuffer displayPath = new StringBuffer();
        if (this.getParent() != null) {
            displayPath.append(this.getParent().getDisplayPath());
        }
        displayPath.append("\\");
        if (this.getDisplayName() != null) {
            displayPath.append(this.getDisplayName());
        }
        return displayPath.toString();
    }

    protected <T extends TFSEntity> T getAncestorOfType(Class<T> type) {
        Check.notNull(type, "type");
        for (TFSEntity ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!type.isInstance(ancestor)) continue;
            return (T)ancestor;
        }
        return null;
    }
}

