/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.location;

import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.LocationMapping;
import com.microsoft.tfs.core.clients.framework.location.RelativeToSetting;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import ms.ws._LocationMapping;
import ms.ws._ServiceDefinition;

public class ServiceDefinition
extends WebServiceObjectWrapper {
    GUID serviceIdentifier;
    RelativeToSetting relativeToSetting;
    LocationMapping[] locationMappings;

    public ServiceDefinition(_ServiceDefinition serviceDefinition) {
        super(serviceDefinition);
        this.serviceIdentifier = new GUID(serviceDefinition.getIdentifier());
        this.relativeToSetting = RelativeToSetting.intToRelativeToSetting(serviceDefinition.getRelativeToSetting());
        this.locationMappings = (LocationMapping[])WrapperUtils.wrap(LocationMapping.class, serviceDefinition.getLocationMappings());
    }

    public _ServiceDefinition getWebServiceObject() {
        return (_ServiceDefinition)this.webServiceObject;
    }

    public Object clone() {
        _ServiceDefinition me = this.getWebServiceObject();
        _ServiceDefinition copy = new _ServiceDefinition();
        copy.setIdentifier(me.getIdentifier());
        copy.setDisplayName(me.getDisplayName());
        copy.setDescription(me.getDescription());
        copy.setRelativePath(me.getRelativePath());
        copy.setRelativeToSetting(me.getRelativeToSetting());
        copy.setServiceType(me.getServiceType());
        copy.setToolId(me.getToolId());
        _LocationMapping[] myLocationMappings = me.getLocationMappings();
        copy.setLocationMappings(new _LocationMapping[myLocationMappings.length]);
        for (int i = 0; i < myLocationMappings.length; ++i) {
            _LocationMapping myLocationMapping = myLocationMappings[i];
            _LocationMapping newLocationMapping = new _LocationMapping();
            newLocationMapping.setAccessMappingMoniker(myLocationMapping.getAccessMappingMoniker());
            newLocationMapping.setLocation(myLocationMapping.getLocation());
            copy.getLocationMappings()[i] = newLocationMapping;
        }
        return new ServiceDefinition(copy);
    }

    public LocationMapping getLocationMapping(AccessMapping accessMapping) {
        Check.notNull(accessMapping, "accessMapping");
        if (this.getRelativeToSetting().toInt() == RelativeToSetting.FULLY_QUALIFIED.toInt()) {
            LocationMapping[] mappings = this.getLocationMappings();
            for (int i = 0; i < mappings.length; ++i) {
                LocationMapping mapping = mappings[i];
                if (!mapping.getAccessMappingMoniker().equalsIgnoreCase(accessMapping.getMoniker())) continue;
                return mapping;
            }
        }
        return null;
    }

    public String getServiceType() {
        return this.getWebServiceObject().getServiceType();
    }

    public String getDisplayName() {
        return this.getWebServiceObject().getDisplayName();
    }

    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    public GUID getIdentifier() {
        return this.serviceIdentifier;
    }

    public String getRelativePath() {
        return this.getWebServiceObject().getRelativePath();
    }

    public RelativeToSetting getRelativeToSetting() {
        return this.relativeToSetting;
    }

    public String getToolID() {
        return this.getWebServiceObject().getToolId();
    }

    public LocationMapping[] getLocationMappings() {
        return this.locationMappings;
    }

    public void internalRemoveLocationMappingAt(int index) {
        Check.isTrue(index >= 0, "index >= 0");
        Check.isTrue(index < this.locationMappings.length, "index < locationMappings.length");
        int count = 0;
        LocationMapping[] newMappings = new LocationMapping[this.locationMappings.length - 1];
        for (int i = 0; i < this.locationMappings.length; ++i) {
            if (i == index) continue;
            newMappings[count++] = this.locationMappings[i];
        }
        this.locationMappings = newMappings;
    }
}

