/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration;

import com.microsoft.tfs.core.clients.registration.internal.ServerMapSerializer;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerMap {
    private static final Log log = LogFactory.getLog(ServerMap.class);
    protected static final String CHILD_STORE_NAME = "TEE-Registration";
    private static final String OBJECT_NAME = "server-map.xml";
    private final Map map = new HashMap();

    public static ServerMap load(PersistenceStore cacheStore) {
        Check.notNull(cacheStore, "cacheStore");
        PersistenceStore mapStore = cacheStore.getChildStore(CHILD_STORE_NAME);
        try {
            if (!mapStore.containsItem(OBJECT_NAME)) {
                return new ServerMap();
            }
            ServerMap map = (ServerMap)mapStore.retrieveItem(OBJECT_NAME, LockMode.WAIT_FOREVER, null, new ServerMapSerializer());
            if (map == null) {
                log.warn((Object)MessageFormat.format("unable to load server map from {0}:{1} (interrupted)", mapStore.toString(), OBJECT_NAME));
                return new ServerMap();
            }
            return map;
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to load server map from {0}:{1}", mapStore.toString(), OBJECT_NAME), (Throwable)e);
            return new ServerMap();
        }
    }

    public void save(PersistenceStore cacheStore) {
        Check.notNull(cacheStore, "cacheStore");
        PersistenceStore mapStore = cacheStore.getChildStore(CHILD_STORE_NAME);
        try {
            mapStore.storeItem(OBJECT_NAME, this, LockMode.WAIT_FOREVER, null, new ServerMapSerializer());
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to save server map to {0}:{1}", mapStore, OBJECT_NAME), (Throwable)e);
        }
    }

    public String[] getURIs() {
        Object[] uris = this.map.keySet().toArray(new String[this.map.size()]);
        Arrays.sort(uris);
        return uris;
    }

    public String getServerID(String uri) {
        Check.notNull(uri, "uri");
        return (String)this.map.get(uri.toLowerCase());
    }

    public void addServerID(String uri, GUID id) {
        Check.notNull(id, "id");
        this.addServerID(uri, id.getGUIDString());
    }

    public void addServerID(String uri, String id) {
        Check.notNull(uri, "uri");
        Check.notNull(id, "id");
        this.map.put(uri.toLowerCase(), id);
    }
}

