/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration.internal;

import com.microsoft.tfs.core.clients.registration.ArtifactType;
import com.microsoft.tfs.core.clients.registration.Database;
import com.microsoft.tfs.core.clients.registration.EventType;
import com.microsoft.tfs.core.clients.registration.OutboundLinkType;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.RegistrationExtendedAttribute;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.util.Check;

public abstract class RegistrationUtilities {
    public static boolean isToolType(String toolId) {
        if (toolId == null) {
            return false;
        }
        if (toolId.trim().length() == 0) {
            return false;
        }
        if (toolId.indexOf(47) != -1) {
            return false;
        }
        if (toolId.indexOf(92) != -1) {
            return false;
        }
        return toolId.indexOf(46) == -1;
    }

    public static RegistrationEntry[] copy(RegistrationEntry[] entries) {
        Check.notNull(entries, "entries");
        RegistrationEntry[] copy = new RegistrationEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            copy[i] = RegistrationUtilities.copy(entries[i]);
        }
        return copy;
    }

    public static RegistrationEntry copy(RegistrationEntry entry) {
        RegistrationExtendedAttribute[] registrationExtendedAttributes;
        ArtifactType[] artifactTypes;
        EventType[] eventTypes;
        Database[] databases;
        Check.notNull(entry, "entry");
        ServiceInterface[] serviceInterfaces = entry.getServiceInterfaces();
        if (serviceInterfaces != null) {
            serviceInterfaces = RegistrationUtilities.copy(serviceInterfaces);
        }
        if ((databases = entry.getDatabases()) != null) {
            databases = RegistrationUtilities.copy(databases);
        }
        if ((eventTypes = entry.getEventTypes()) != null) {
            eventTypes = RegistrationUtilities.copy(eventTypes);
        }
        if ((artifactTypes = entry.getArtifactTypes()) != null) {
            artifactTypes = RegistrationUtilities.copy(artifactTypes);
        }
        if ((registrationExtendedAttributes = entry.getRegistrationExtendedAttributes()) != null) {
            registrationExtendedAttributes = RegistrationUtilities.copy(registrationExtendedAttributes);
        }
        return new RegistrationEntry(entry.getType(), serviceInterfaces, databases, eventTypes, artifactTypes, registrationExtendedAttributes);
    }

    public static ServiceInterface[] copy(ServiceInterface[] serviceInterfaces) {
        Check.notNull(serviceInterfaces, "serviceInterfaces");
        ServiceInterface[] copy = new ServiceInterface[serviceInterfaces.length];
        for (int i = 0; i < serviceInterfaces.length; ++i) {
            copy[i] = RegistrationUtilities.copy(serviceInterfaces[i]);
        }
        return copy;
    }

    public static ServiceInterface copy(ServiceInterface serviceInterface) {
        Check.notNull(serviceInterface, "serviceInterface");
        return new ServiceInterface(serviceInterface.getName(), serviceInterface.getURL());
    }

    public static Database[] copy(Database[] databases) {
        Check.notNull(databases, "databases");
        Database[] copy = new Database[databases.length];
        for (int i = 0; i < databases.length; ++i) {
            copy[i] = RegistrationUtilities.copy(databases[i]);
        }
        return copy;
    }

    public static Database copy(Database database) {
        Check.notNull(database, "database");
        return new Database(database.getName(), database.getDatabaseName(), database.getSQLServerName(), database.getConnectionString(), database.isExcludeFromBackup());
    }

    public static EventType[] copy(EventType[] eventTypes) {
        Check.notNull(eventTypes, "eventTypes");
        EventType[] copy = new EventType[eventTypes.length];
        for (int i = 0; i < eventTypes.length; ++i) {
            copy[i] = RegistrationUtilities.copy(eventTypes[i]);
        }
        return copy;
    }

    public static EventType copy(EventType eventType) {
        Check.notNull(eventType, "eventType");
        return new EventType(eventType.getName(), eventType.getSchema());
    }

    public static ArtifactType[] copy(ArtifactType[] artifactTypes) {
        Check.notNull(artifactTypes, "artifactTypes");
        ArtifactType[] copy = new ArtifactType[artifactTypes.length];
        for (int i = 0; i < artifactTypes.length; ++i) {
            copy[i] = RegistrationUtilities.copy(artifactTypes[i]);
        }
        return copy;
    }

    public static ArtifactType copy(ArtifactType artifactType) {
        Check.notNull(artifactType, "artifactType");
        OutboundLinkType[] outboundLinkTypes = artifactType.getOutboundLinkTypes();
        if (outboundLinkTypes != null) {
            outboundLinkTypes = RegistrationUtilities.copy(outboundLinkTypes);
        }
        return new ArtifactType(artifactType.getName(), outboundLinkTypes);
    }

    public static OutboundLinkType[] copy(OutboundLinkType[] outboundLinkTypes) {
        Check.notNull(outboundLinkTypes, "outboundLinkTypes");
        OutboundLinkType[] copy = new OutboundLinkType[outboundLinkTypes.length];
        for (int i = 0; i < outboundLinkTypes.length; ++i) {
            copy[i] = RegistrationUtilities.copy(outboundLinkTypes[i]);
        }
        return copy;
    }

    public static OutboundLinkType copy(OutboundLinkType outboundLinkType) {
        Check.notNull(outboundLinkType, "outboundLinkType");
        return new OutboundLinkType(outboundLinkType.getName(), outboundLinkType.getTargetArtifactTypeTool(), outboundLinkType.getTargetArtifactTypeName());
    }

    public static RegistrationExtendedAttribute[] copy(RegistrationExtendedAttribute[] registrationExtendedAttributes) {
        Check.notNull(registrationExtendedAttributes, "registrationExtendedAttributes");
        RegistrationExtendedAttribute[] copy = new RegistrationExtendedAttribute[registrationExtendedAttributes.length];
        for (int i = 0; i < registrationExtendedAttributes.length; ++i) {
            copy[i] = RegistrationUtilities.copy(registrationExtendedAttributes[i]);
        }
        return copy;
    }

    public static RegistrationExtendedAttribute copy(RegistrationExtendedAttribute registrationExtendedAttribute) {
        Check.notNull(registrationExtendedAttribute, "registrationExtendedAttribute");
        return new RegistrationExtendedAttribute(registrationExtendedAttribute.getName(), registrationExtendedAttribute.getValue());
    }
}

